/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.render;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.spec.FontSpec;
import com.helger.pdflayout.spec.LoadedFont;
import com.helger.pdflayout.spec.PreloadFont;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pdfbox.pdmodel.PDDocument;

@NotThreadSafe
public final class PreparationContextGlobal {
    private final PDDocument m_aDoc;
    private final ICommonsMap<PreloadFont, LoadedFont> m_aFontCache = new CommonsHashMap();

    public PreparationContextGlobal(@Nonnull PDDocument pDDocument) {
        ValueEnforcer.notNull((Object)pDDocument, (String)"PDDocument");
        this.m_aDoc = pDDocument;
    }

    @Nonnull
    public PDDocument getDocument() {
        return this.m_aDoc;
    }

    @Nonnull
    public LoadedFont getLoadedFont(@Nonnull FontSpec fontSpec) throws IOException {
        PreloadFont preloadFont = fontSpec.getPreloadFont();
        LoadedFont loadedFont = (LoadedFont)this.m_aFontCache.get((Object)preloadFont);
        if (loadedFont == null) {
            if (PLDebugLog.isDebugFont()) {
                PLDebugLog.debugFont(preloadFont.toString(), "Loading into current document");
            }
            loadedFont = new LoadedFont(preloadFont.loadPDFont(this.m_aDoc), preloadFont.getFallbackCodePoint());
            this.m_aFontCache.put((Object)preloadFont, (Object)loadedFont);
        }
        return loadedFont;
    }
}

