/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.spec.BorderStyleSpec;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class BorderSpec
implements Serializable {
    public static final BorderSpec BORDER0 = new BorderSpec(null, null, null, null);
    private final BorderStyleSpec m_aTop;
    private final BorderStyleSpec m_aRight;
    private final BorderStyleSpec m_aBottom;
    private final BorderStyleSpec m_aLeft;

    public BorderSpec(@Nullable BorderStyleSpec borderStyleSpec) {
        this(borderStyleSpec, borderStyleSpec);
    }

    public BorderSpec(@Nullable BorderStyleSpec borderStyleSpec, @Nullable BorderStyleSpec borderStyleSpec2) {
        this(borderStyleSpec, borderStyleSpec2, borderStyleSpec, borderStyleSpec2);
    }

    public BorderSpec(@Nullable BorderStyleSpec borderStyleSpec, @Nullable BorderStyleSpec borderStyleSpec2, @Nullable BorderStyleSpec borderStyleSpec3, @Nullable BorderStyleSpec borderStyleSpec4) {
        this.m_aLeft = borderStyleSpec4;
        this.m_aTop = borderStyleSpec;
        this.m_aRight = borderStyleSpec2;
        this.m_aBottom = borderStyleSpec3;
    }

    public final boolean hasAllBorders() {
        return this.m_aTop != null && this.m_aRight != null && this.m_aBottom != null && this.m_aLeft != null;
    }

    public final boolean hasAnyBorder() {
        return this.m_aTop != null || this.m_aRight != null || this.m_aBottom != null || this.m_aLeft != null;
    }

    public boolean areAllBordersEqual() {
        return EqualsHelper.equals((Object)this.m_aLeft, (Object)this.m_aTop) && EqualsHelper.equals((Object)this.m_aLeft, (Object)this.m_aRight) && EqualsHelper.equals((Object)this.m_aLeft, (Object)this.m_aBottom);
    }

    @Nullable
    public final BorderStyleSpec getTop() {
        return this.m_aTop;
    }

    @Nullable
    public final BorderStyleSpec getRight() {
        return this.m_aRight;
    }

    @Nullable
    public final BorderStyleSpec getBottom() {
        return this.m_aBottom;
    }

    @Nullable
    public final BorderStyleSpec getLeft() {
        return this.m_aLeft;
    }

    public final float getTopWidth() {
        BorderStyleSpec borderStyleSpec = this.m_aTop;
        return borderStyleSpec == null ? 0.0f : borderStyleSpec.getLineWidth();
    }

    public final float getRightWidth() {
        BorderStyleSpec borderStyleSpec = this.m_aRight;
        return borderStyleSpec == null ? 0.0f : borderStyleSpec.getLineWidth();
    }

    public final float getBottomWidth() {
        BorderStyleSpec borderStyleSpec = this.m_aBottom;
        return borderStyleSpec == null ? 0.0f : borderStyleSpec.getLineWidth();
    }

    public final float getLeftWidth() {
        BorderStyleSpec borderStyleSpec = this.m_aLeft;
        return borderStyleSpec == null ? 0.0f : borderStyleSpec.getLineWidth();
    }

    public final float getXSumWidth() {
        return this.getLeftWidth() + this.getRightWidth();
    }

    public final float getYSumWidth() {
        return this.getTopWidth() + this.getBottomWidth();
    }

    @Nonnull
    public BorderSpec getCloneWithTop(@Nullable BorderStyleSpec borderStyleSpec) {
        if (EqualsHelper.equals((Object)borderStyleSpec, (Object)this.m_aTop)) {
            return this;
        }
        return new BorderSpec(borderStyleSpec, this.m_aRight, this.m_aBottom, this.m_aLeft);
    }

    @Nonnull
    public BorderSpec getCloneWithRight(@Nullable BorderStyleSpec borderStyleSpec) {
        if (EqualsHelper.equals((Object)borderStyleSpec, (Object)this.m_aRight)) {
            return this;
        }
        return new BorderSpec(this.m_aTop, borderStyleSpec, this.m_aBottom, this.m_aLeft);
    }

    @Nonnull
    public BorderSpec getCloneWithBottom(@Nullable BorderStyleSpec borderStyleSpec) {
        if (EqualsHelper.equals((Object)borderStyleSpec, (Object)this.m_aBottom)) {
            return this;
        }
        return new BorderSpec(this.m_aTop, this.m_aRight, borderStyleSpec, this.m_aLeft);
    }

    @Nonnull
    public BorderSpec getCloneWithLeft(@Nullable BorderStyleSpec borderStyleSpec) {
        if (EqualsHelper.equals((Object)borderStyleSpec, (Object)this.m_aLeft)) {
            return this;
        }
        return new BorderSpec(this.m_aTop, this.m_aRight, this.m_aBottom, borderStyleSpec);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BorderSpec borderSpec = (BorderSpec)object;
        return EqualsHelper.equals((Object)this.m_aTop, (Object)borderSpec.m_aTop) && EqualsHelper.equals((Object)this.m_aRight, (Object)borderSpec.m_aRight) && EqualsHelper.equals((Object)this.m_aBottom, (Object)borderSpec.m_aBottom) && EqualsHelper.equals((Object)this.m_aLeft, (Object)borderSpec.m_aLeft);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aTop).append((Object)this.m_aRight).append((Object)this.m_aBottom).append((Object)this.m_aLeft).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("left", (Object)this.m_aLeft).appendIfNotNull("top", (Object)this.m_aTop).appendIfNotNull("right", (Object)this.m_aRight).appendIfNotNull("bottom", (Object)this.m_aBottom).getToString();
    }

    @Nonnull
    public static BorderSpec top(@Nullable BorderStyleSpec borderStyleSpec) {
        return new BorderSpec(borderStyleSpec, null, null, null);
    }

    @Nonnull
    public static BorderSpec right(@Nullable BorderStyleSpec borderStyleSpec) {
        return new BorderSpec(null, borderStyleSpec, null, null);
    }

    @Nonnull
    public static BorderSpec bottom(@Nullable BorderStyleSpec borderStyleSpec) {
        return new BorderSpec(null, null, borderStyleSpec, null);
    }

    @Nonnull
    public static BorderSpec left(@Nullable BorderStyleSpec borderStyleSpec) {
        return new BorderSpec(null, null, null, borderStyleSpec);
    }
}

