/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.pdflayout.PLConvert;
import com.helger.pdflayout.spec.AbstractRectSpec;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class PaddingSpec
extends AbstractRectSpec {
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final PaddingSpec PADDING0 = new PaddingSpec(0.0f, 0.0f, 0.0f, 0.0f);

    public PaddingSpec(@Nonnull AbstractRectSpec abstractRectSpec) {
        super(abstractRectSpec);
    }

    public PaddingSpec(float f) {
        this(f, f);
    }

    public PaddingSpec(float f, float f2) {
        this(f, f2, f, f2);
    }

    public PaddingSpec(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    @Nonnull
    public PaddingSpec getCloneWithTop(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fTop)) {
            return this;
        }
        return new PaddingSpec(f, this.m_fRight, this.m_fBottom, this.m_fLeft);
    }

    @Nonnull
    public PaddingSpec getCloneWithRight(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fRight)) {
            return this;
        }
        return new PaddingSpec(this.m_fTop, f, this.m_fBottom, this.m_fLeft);
    }

    @Nonnull
    public PaddingSpec getCloneWithBottom(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fBottom)) {
            return this;
        }
        return new PaddingSpec(this.m_fTop, this.m_fRight, f, this.m_fLeft);
    }

    @Nonnull
    public PaddingSpec getCloneWithLeft(float f) {
        if (EqualsHelper.equals((float)f, (float)this.m_fLeft)) {
            return this;
        }
        return new PaddingSpec(this.m_fTop, this.m_fRight, this.m_fBottom, f);
    }

    @Nonnull
    public static PaddingSpec createMM(float f) {
        return new PaddingSpec(PLConvert.mm2units(f));
    }

    @Nonnull
    public static PaddingSpec createMM(float f, float f2) {
        return new PaddingSpec(PLConvert.mm2units(f), PLConvert.mm2units(f2));
    }

    @Nonnull
    public static PaddingSpec createMM(float f, float f2, float f3, float f4) {
        return new PaddingSpec(PLConvert.mm2units(f), PLConvert.mm2units(f2), PLConvert.mm2units(f3), PLConvert.mm2units(f4));
    }

    @Nonnull
    public static PaddingSpec top(float f) {
        return new PaddingSpec(f, 0.0f, 0.0f, 0.0f);
    }

    @Nonnull
    public static PaddingSpec right(float f) {
        return new PaddingSpec(0.0f, f, 0.0f, 0.0f);
    }

    @Nonnull
    public static PaddingSpec bottom(float f) {
        return new PaddingSpec(0.0f, 0.0f, f, 0.0f);
    }

    @Nonnull
    public static PaddingSpec left(float f) {
        return new PaddingSpec(0.0f, 0.0f, 0.0f, f);
    }
}

