/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.PLConvert;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

@Immutable
@MustImplementEqualsAndHashcode
public class SizeSpec
implements Serializable {
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final SizeSpec SIZE0 = new SizeSpec(0.0f, 0.0f);
    public static final SizeSpec SIZE_MAX = new SizeSpec(Float.MAX_VALUE, Float.MAX_VALUE);
    private final float m_fWidth;
    private final float m_fHeight;

    public SizeSpec(@Nonnegative float f, @Nonnegative float f2) {
        this.m_fWidth = f;
        this.m_fHeight = f2;
    }

    @Nonnegative
    public final float getWidth() {
        return this.m_fWidth;
    }

    @Nonnegative
    public final float getHeight() {
        return this.m_fHeight;
    }

    @Nonnull
    public PDRectangle getAsRectangle() {
        return new PDRectangle(this.m_fWidth, this.m_fHeight);
    }

    @Nonnull
    @CheckReturnValue
    public SizeSpec plus(float f, float f2) {
        return new SizeSpec(this.m_fWidth + f, this.m_fHeight + f2);
    }

    @Nonnull
    @CheckReturnValue
    public SizeSpec plus(@Nonnull SizeSpec sizeSpec) {
        return this.plus(sizeSpec.m_fWidth, sizeSpec.m_fHeight);
    }

    @Nonnull
    @CheckReturnValue
    public SizeSpec minus(float f, float f2) {
        return new SizeSpec(this.m_fWidth - f, this.m_fHeight - f2);
    }

    @Nonnull
    @CheckReturnValue
    public SizeSpec minus(@Nonnull SizeSpec sizeSpec) {
        return this.minus(sizeSpec.m_fWidth, sizeSpec.m_fHeight);
    }

    @Nonnull
    @CheckReturnValue
    public SizeSpec withWidth(float f) {
        return new SizeSpec(f, this.m_fHeight);
    }

    @Nonnull
    @CheckReturnValue
    public SizeSpec withHeight(float f) {
        return new SizeSpec(this.m_fWidth, f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SizeSpec sizeSpec = (SizeSpec)object;
        return EqualsHelper.equals((float)this.m_fWidth, (float)sizeSpec.m_fWidth) && EqualsHelper.equals((float)this.m_fHeight, (float)sizeSpec.m_fHeight);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_fWidth).append(this.m_fHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Width", this.m_fWidth).append("Height", this.m_fHeight).getToString();
    }

    @Nonnull
    public static SizeSpec create(@Nonnull PDRectangle pDRectangle) {
        return new SizeSpec(pDRectangle.getWidth(), pDRectangle.getHeight());
    }

    @Nonnull
    public static SizeSpec createMM(float f, float f2) {
        return new SizeSpec(PLConvert.mm2units(f), PLConvert.mm2units(f2));
    }

    @Nonnull
    public static SizeSpec width(float f) {
        return new SizeSpec(f, 0.0f);
    }

    @Nonnull
    public static SizeSpec height(float f) {
        return new SizeSpec(0.0f, f);
    }
}

