/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class TextAndWidthSpec
implements Serializable {
    private final String m_sText;
    private final float m_fWidth;

    public TextAndWidthSpec(@Nonnull String string, @Nonnegative float f) {
        ValueEnforcer.notNull((Object)string, (String)"Text");
        ValueEnforcer.isGE0((float)f, (String)"Width");
        this.m_sText = string;
        this.m_fWidth = f;
    }

    @Nonnull
    public final String getText() {
        return this.m_sText;
    }

    @Nonnegative
    public final float getWidth() {
        return this.m_fWidth;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TextAndWidthSpec textAndWidthSpec = (TextAndWidthSpec)object;
        return this.m_sText.equals(textAndWidthSpec.m_sText) && EqualsHelper.equals((float)this.m_fWidth, (float)textAndWidthSpec.m_fWidth);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sText).append(this.m_fWidth).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("text", (Object)this.m_sText).append("width", this.m_fWidth).getToString();
    }
}

