/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.IPLObject;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPLObject<IMPLTYPE extends AbstractPLObject<IMPLTYPE>>
implements IPLObject<IMPLTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPLObject.class);
    private String m_sElementID = GlobalIDFactory.getNewStringID();
    private transient String m_sDebugID;

    public final String getID() {
        return this.m_sElementID;
    }

    @OverrideOnDemand
    protected void onAfterSetID() {
    }

    @Nonnull
    public final IMPLTYPE setID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        if (this.m_sDebugID != null) {
            LOGGER.warn("Overwriting ID '" + this.m_sElementID + "' with ID '" + string + "'");
            this.m_sDebugID = null;
        }
        this.m_sElementID = string;
        this.onAfterSetID();
        return (IMPLTYPE)((AbstractPLObject)this.thisAsT());
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getDebugID() {
        Object object = this.m_sDebugID;
        if (object == null) {
            this.m_sDebugID = object = "<" + ClassHelper.getClassLocalName((Object)this) + "-" + this.getID() + ">";
        }
        return object;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        return (IMPLTYPE)((AbstractPLObject)this.thisAsT());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ElementID", (Object)this.m_sElementID).getToString();
    }
}

