/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.traits.IGenericImplTrait;
import com.helger.pdflayout.base.IPLHasOutline;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.spec.BorderSpec;
import com.helger.pdflayout.spec.BorderStyleSpec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPLHasBorder<IMPLTYPE extends IPLHasBorder<IMPLTYPE>>
extends IPLHasOutline,
IGenericImplTrait<IMPLTYPE> {
    public static final BorderSpec DEFAULT_BORDER = BorderSpec.BORDER0;

    @Nonnull
    default public IMPLTYPE setBorder(@Nonnull PLColor pLColor) {
        return this.setBorder(new BorderStyleSpec(pLColor));
    }

    @Nonnull
    default public IMPLTYPE setBorder(@Nullable BorderStyleSpec borderStyleSpec) {
        return this.setBorder(new BorderSpec(borderStyleSpec));
    }

    @Nonnull
    default public IMPLTYPE setBorder(@Nullable BorderStyleSpec borderStyleSpec, @Nullable BorderStyleSpec borderStyleSpec2) {
        return this.setBorder(new BorderSpec(borderStyleSpec, borderStyleSpec2));
    }

    @Nonnull
    default public IMPLTYPE setBorder(@Nullable BorderStyleSpec borderStyleSpec, @Nullable BorderStyleSpec borderStyleSpec2, @Nullable BorderStyleSpec borderStyleSpec3, @Nullable BorderStyleSpec borderStyleSpec4) {
        return this.setBorder(new BorderSpec(borderStyleSpec, borderStyleSpec2, borderStyleSpec3, borderStyleSpec4));
    }

    @Nonnull
    public IMPLTYPE setBorder(@Nonnull BorderSpec var1);

    @Nonnull
    default public IMPLTYPE setBorderTop(@Nullable BorderStyleSpec borderStyleSpec) {
        return this.setBorder(this.getBorder().getCloneWithTop(borderStyleSpec));
    }

    @Nonnull
    default public IMPLTYPE setBorderRight(@Nullable BorderStyleSpec borderStyleSpec) {
        return this.setBorder(this.getBorder().getCloneWithRight(borderStyleSpec));
    }

    @Nonnull
    default public IMPLTYPE setBorderBottom(@Nullable BorderStyleSpec borderStyleSpec) {
        return this.setBorder(this.getBorder().getCloneWithBottom(borderStyleSpec));
    }

    @Nonnull
    default public IMPLTYPE setBorderLeft(@Nullable BorderStyleSpec borderStyleSpec) {
        return this.setBorder(this.getBorder().getCloneWithLeft(borderStyleSpec));
    }

    @Nonnull
    default public IMPLTYPE setBorderX(@Nullable BorderStyleSpec borderStyleSpec) {
        return this.setBorderLeft(borderStyleSpec).setBorderRight(borderStyleSpec);
    }

    @Nonnull
    default public IMPLTYPE setBorderY(@Nullable BorderStyleSpec borderStyleSpec) {
        return this.setBorderTop(borderStyleSpec).setBorderBottom(borderStyleSpec);
    }

    @Nonnull
    public BorderSpec getBorder();

    default public float getBorderTopWidth() {
        return this.getBorder().getTopWidth();
    }

    default public float getBorderRightWidth() {
        return this.getBorder().getRightWidth();
    }

    default public float getBorderBottomWidth() {
        return this.getBorder().getBottomWidth();
    }

    default public float getBorderLeftWidth() {
        return this.getBorder().getLeftWidth();
    }

    default public float getBorderXSumWidth() {
        return this.getBorder().getXSumWidth();
    }

    default public float getBorderYSumWidth() {
        return this.getBorder().getYSumWidth();
    }

    @Override
    default public float getOutlineTop() {
        return this.getBorderTopWidth();
    }

    @Override
    default public float getOutlineRight() {
        return this.getBorderRightWidth();
    }

    @Override
    default public float getOutlineBottom() {
        return this.getBorderBottomWidth();
    }

    @Override
    default public float getOutlineLeft() {
        return this.getBorderLeftWidth();
    }

    @Override
    default public float getOutlineXSum() {
        return this.getBorderXSumWidth();
    }

    @Override
    default public float getOutlineYSum() {
        return this.getBorderYSumWidth();
    }
}

