/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.debug;

import com.helger.commons.ValueEnforcer;
import com.helger.pdflayout.base.IPLHasMarginBorderPadding;
import com.helger.pdflayout.base.IPLObject;
import com.helger.pdflayout.spec.SizeSpec;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class PLDebugLog {
    public static final boolean DEFAULT_DEBUG = false;
    private static IPLDebugOutput s_aDebugOutput = new PLDebugOutputLogger();
    private static boolean s_bDebugText = false;
    private static boolean s_bDebugFont = false;
    private static boolean s_bDebugSplit = false;
    private static boolean s_bDebugPrepare = false;
    private static boolean s_bDebugRender = false;

    private PLDebugLog() {
    }

    @Nonnull
    public static IPLDebugOutput getDebugOutput() {
        return s_aDebugOutput;
    }

    public static void setDebugOutput(@Nonnull IPLDebugOutput iPLDebugOutput) {
        ValueEnforcer.notNull((Object)iPLDebugOutput, (String)"DebugOutput");
        s_aDebugOutput = iPLDebugOutput;
    }

    public static boolean isDebugText() {
        return s_bDebugText;
    }

    public static void setDebugText(boolean bl) {
        s_bDebugText = bl;
    }

    public static void debugText(@Nonnull IPLObject<?> iPLObject, String string) {
        if (s_aDebugOutput.isEnabled()) {
            s_aDebugOutput.log("[Text] " + iPLObject.getDebugID() + " " + string);
        }
    }

    public static boolean isDebugFont() {
        return s_bDebugFont;
    }

    public static void setDebugFont(boolean bl) {
        s_bDebugFont = bl;
    }

    public static void debugFont(@Nonnull String string, String string2) {
        if (s_aDebugOutput.isEnabled()) {
            s_aDebugOutput.log("[Font] " + string + " " + string2);
        }
    }

    public static boolean isDebugSplit() {
        return s_bDebugSplit;
    }

    public static void setDebugSplit(boolean bl) {
        s_bDebugSplit = bl;
    }

    public static void debugSplit(@Nonnull IPLObject<?> iPLObject, String string) {
        if (s_aDebugOutput.isEnabled()) {
            s_aDebugOutput.log("[Splitting] " + iPLObject.getDebugID() + " " + string);
        }
    }

    public static boolean isDebugPrepare() {
        return s_bDebugPrepare;
    }

    public static void setDebugPrepare(boolean bl) {
        s_bDebugPrepare = bl;
    }

    public static void debugPrepare(@Nonnull IPLObject<?> iPLObject, String string) {
        if (s_aDebugOutput.isEnabled()) {
            s_aDebugOutput.log("[Preparing] " + iPLObject.getDebugID() + " " + string);
        }
    }

    public static boolean isDebugRender() {
        return s_bDebugRender;
    }

    public static void setDebugRender(boolean bl) {
        s_bDebugRender = bl;
    }

    public static void debugRender(@Nonnull IPLObject<?> iPLObject, String string) {
        if (s_aDebugOutput.isEnabled()) {
            s_aDebugOutput.log("[Rendering] " + iPLObject.getDebugID() + " " + string);
        }
    }

    public static void setDebugAll(boolean bl) {
        PLDebugLog.setDebugFont(bl);
        PLDebugLog.setDebugPrepare(bl);
        PLDebugLog.setDebugRender(bl);
        PLDebugLog.setDebugSplit(bl);
        PLDebugLog.setDebugText(bl);
    }

    @Nonnull
    public static String getXY(float f, float f2) {
        return "[" + f + "/" + f2 + "]";
    }

    @Nonnull
    public static String getWH(@Nonnull SizeSpec sizeSpec) {
        return PLDebugLog.getWH(sizeSpec.getWidth(), sizeSpec.getHeight());
    }

    @Nonnull
    public static String getWH(float f, float f2) {
        return f + "/" + f2;
    }

    @Nonnull
    public static String getXYWH(float f, float f2, float f3, float f4) {
        float f5 = f + f3;
        float f6 = f2 - f4;
        return "LB" + PLDebugLog.getXY(f, f6) + " - RT" + PLDebugLog.getXY(f5, f2) + " (=WH " + PLDebugLog.getWH(f3, f4) + ")";
    }

    @Nonnull
    public static String getXMBP(@Nonnull IPLHasMarginBorderPadding<?> iPLHasMarginBorderPadding) {
        return "[X-MBP: " + iPLHasMarginBorderPadding.getMarginXSum() + "/" + iPLHasMarginBorderPadding.getBorderXSumWidth() + "/" + iPLHasMarginBorderPadding.getPaddingXSum() + "=" + iPLHasMarginBorderPadding.getOutlineXSum() + "]";
    }

    @Nonnull
    public static String getYMBP(@Nonnull IPLHasMarginBorderPadding<?> iPLHasMarginBorderPadding) {
        return "[Y-MBP: " + iPLHasMarginBorderPadding.getMarginYSum() + "/" + iPLHasMarginBorderPadding.getBorderYSumWidth() + "/" + iPLHasMarginBorderPadding.getPaddingYSum() + "=" + iPLHasMarginBorderPadding.getOutlineYSum() + "]";
    }

    public static interface IPLDebugOutput {
        public boolean isEnabled();

        public void log(@Nonnull String var1);
    }

    public static class PLDebugOutputLogger
    implements IPLDebugOutput {
        private static final Logger LOGGER = LoggerFactory.getLogger(PLDebugOutputLogger.class);

        @Override
        public boolean isEnabled() {
            return LOGGER.isInfoEnabled();
        }

        @Override
        public void log(String string) {
            LOGGER.info(string);
        }
    }
}

