/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.debug;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.pdflayout.base.IPLBlockElement;
import com.helger.pdflayout.base.IPLInlineElement;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.base.PLPageSet;
import com.helger.pdflayout.spec.BorderStyleSpec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PLDebugRender {
    public static final boolean DEFAULT_DEBUG_RENDER = false;
    public static final PLColor DEFAULT_COLOR_OUTLINE_PAGESET = new PLColor(128, 128, 128);
    public static final PLColor DEFAULT_COLOR_OUTLINE_BLOCK_ELEMENT = new PLColor(160, 160, 160);
    public static final PLColor DEFAULT_COLOR_OUTLINE_INLINE_ELEMENT = new PLColor(192, 192, 192);
    public static final BorderStyleSpec DEFAULT_BORDER_PAGESET = new BorderStyleSpec(PLColor.RED);
    public static final BorderStyleSpec DEFAULT_BORDER_BLOCK_ELEMENT = new BorderStyleSpec(PLColor.BLUE);
    public static final BorderStyleSpec DEFAULT_BORDER_INLINE_ELEMENT = new BorderStyleSpec(PLColor.GREEN);
    private static boolean s_bDebugRender;
    private static IDebugColorProvider s_aDebugOutlineColorProvider;
    private static IDebugBorderProvider s_aDebugBorderProvider;

    private PLDebugRender() {
    }

    public static void resetToDefault() {
        s_bDebugRender = false;
        s_aDebugOutlineColorProvider = IDebugColorProvider.getDefaultOutlineProvider();
        s_aDebugBorderProvider = IDebugBorderProvider.getDefaultBorderProvider();
    }

    public static boolean isDebugRender() {
        return s_bDebugRender;
    }

    public static void setDebugRender(boolean bl) {
        s_bDebugRender = bl;
    }

    public static void setDebugOutlineColorProvider(@Nonnull IDebugColorProvider iDebugColorProvider) {
        ValueEnforcer.notNull((Object)iDebugColorProvider, (String)"DebugOutlineColorProvider");
        s_aDebugOutlineColorProvider = iDebugColorProvider;
    }

    @Nullable
    public static PLColor getDebugOutlineColor(@Nonnull Object object) {
        return s_aDebugOutlineColorProvider.getDebugColor(object);
    }

    public static void setDebugBorderProvider(@Nonnull IDebugBorderProvider iDebugBorderProvider) {
        ValueEnforcer.notNull((Object)iDebugBorderProvider, (String)"DebugBorderProvider");
        s_aDebugBorderProvider = iDebugBorderProvider;
    }

    @Nullable
    public static BorderStyleSpec getDebugBorder(@Nonnull Object object) {
        return s_aDebugBorderProvider.getDebugBorder(object);
    }

    public static <EXTYPE extends Throwable> void withDebugRender(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        PLDebugRender.withDebugRender(true, iThrowingRunnable);
    }

    public static <EXTYPE extends Throwable> void withDebugRender(boolean bl, @Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        PLDebugRender.setDebugRender(bl);
        try {
            iThrowingRunnable.run();
        }
        finally {
            PLDebugRender.resetToDefault();
        }
    }

    static {
        PLDebugRender.resetToDefault();
    }

    @FunctionalInterface
    public static interface IDebugColorProvider {
        @Nullable
        public PLColor getDebugColor(@Nonnull Object var1);

        @Nonnull
        public static IDebugColorProvider getDefaultOutlineProvider() {
            return object -> {
                if (object instanceof PLPageSet) {
                    return DEFAULT_COLOR_OUTLINE_PAGESET;
                }
                if (object instanceof IPLBlockElement) {
                    return DEFAULT_COLOR_OUTLINE_BLOCK_ELEMENT;
                }
                if (object instanceof IPLInlineElement) {
                    return DEFAULT_COLOR_OUTLINE_INLINE_ELEMENT;
                }
                return null;
            };
        }
    }

    @FunctionalInterface
    public static interface IDebugBorderProvider {
        @Nullable
        public BorderStyleSpec getDebugBorder(@Nonnull Object var1);

        @Nonnull
        public static IDebugBorderProvider getDefaultBorderProvider() {
            return object -> {
                if (object instanceof PLPageSet) {
                    return DEFAULT_BORDER_PAGESET;
                }
                if (object instanceof IPLBlockElement) {
                    return DEFAULT_BORDER_BLOCK_ELEMENT;
                }
                if (object instanceof IPLInlineElement) {
                    return DEFAULT_BORDER_INLINE_ELEMENT;
                }
                return null;
            };
        }
    }
}

