/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.hbox;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.spec.WidthSpec;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PLHBoxColumn {
    private IPLRenderableObject<?> m_aElement;
    private WidthSpec m_aWidth;

    public PLHBoxColumn(@Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull WidthSpec widthSpec) {
        this.internalSetElement(iPLRenderableObject);
        this.internalSetWidth(widthSpec);
    }

    @Nonnull
    public IPLRenderableObject<?> getElement() {
        return this.m_aElement;
    }

    @Nonnull
    PLHBoxColumn internalSetElement(@Nonnull IPLRenderableObject<?> iPLRenderableObject) {
        this.m_aElement = (IPLRenderableObject)ValueEnforcer.notNull(iPLRenderableObject, (String)"Element");
        return this;
    }

    @Nonnull
    public WidthSpec getWidth() {
        return this.m_aWidth;
    }

    @Nonnull
    PLHBoxColumn internalSetWidth(@Nonnull WidthSpec widthSpec) {
        this.m_aWidth = (WidthSpec)ValueEnforcer.notNull((Object)widthSpec, (String)"Width");
        return this;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Element", this.m_aElement).append("Width", (Object)this.m_aWidth).getToString();
    }
}

