/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.image;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.element.image.AbstractPLImage;
import com.helger.pdflayout.render.PagePreRenderContext;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.CCITTFactory;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PLStreamImage
extends AbstractPLImage<PLStreamImage> {
    private final IHasInputStream m_aIIS;

    public PLStreamImage(@Nonnull IHasInputStream iHasInputStream, @Nonnegative float f, @Nonnegative float f2) {
        super(f, f2);
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"Image");
        this.m_aIIS = iHasInputStream;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public PLStreamImage setBasicDataFrom(@Nonnull PLStreamImage pLStreamImage) {
        super.setBasicDataFrom(pLStreamImage);
        return this;
    }

    @Nullable
    public IHasInputStream getIIS() {
        return this.m_aIIS;
    }

    @Override
    @Nonnull
    protected PDImageXObject getXObject(@Nonnull PagePreRenderContext pagePreRenderContext) throws IOException {
        InputStream inputStream = this.m_aIIS.getInputStream();
        if (inputStream == null) {
            throw new IOException("Failed to open InputStream from " + this.m_aIIS);
        }
        try (InputStream inputStream2 = inputStream;){
            byte[] byArray = StreamHelper.getAllBytes((InputStream)inputStream2);
            switch (this.getImageType()) {
                case CCITT: {
                    PDImageXObject pDImageXObject = CCITTFactory.createFromByteArray((PDDocument)pagePreRenderContext.getDocument(), (byte[])byArray);
                    return pDImageXObject;
                }
                case JPEG: {
                    PDImageXObject pDImageXObject = JPEGFactory.createFromByteArray((PDDocument)pagePreRenderContext.getDocument(), (byte[])byArray);
                    return pDImageXObject;
                }
                case LOSSLESS: {
                    throw new IllegalStateException("Lossless images cannot be read from Stream - use the version with BufferedImage!");
                }
            }
            throw new IllegalStateException("Unsupported image type: " + this.toString());
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("IIS", (Object)this.m_aIIS).getToString();
    }
}

