/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.list;

import com.helger.pdflayout.PLConvert;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.element.list.BulletPointCreatorConstant;
import com.helger.pdflayout.element.text.PLText;
import com.helger.pdflayout.spec.FontSpec;
import com.helger.pdflayout.spec.PreloadFont;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class BulletPointCreatorSymbol
extends BulletPointCreatorConstant {
    public BulletPointCreatorSymbol(char c, @Nonnegative float f) {
        super(Character.toString(c), new FontSpec(PreloadFont.SYMBOL, f));
    }

    @Override
    @Nonnull
    public IPLRenderableObject<?> getBulletPointElement(@Nonnegative int n) {
        PLText pLText = (PLText)super.getBulletPointElement(n);
        pLText.setCustomAscentFirstLine(PLConvert.getWidthForFontSize(450.0f, this.getFontSpec().getFontSize()));
        return pLText;
    }

    @Nonnull
    public static BulletPointCreatorSymbol createFilledDot(@Nonnegative float f) {
        return new BulletPointCreatorSymbol('\u00b7', f);
    }

    @Nonnull
    public static BulletPointCreatorSymbol createEmptyDot(@Nonnegative float f) {
        return new BulletPointCreatorSymbol('\u00b0', f);
    }
}

