/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.table;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLRenderableObject;
import com.helger.pdflayout.base.IPLHasMargin;
import com.helger.pdflayout.base.IPLSplittableObject;
import com.helger.pdflayout.base.IPLVisitor;
import com.helger.pdflayout.base.PLElementWithSize;
import com.helger.pdflayout.base.PLSplitResult;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.element.special.PLSpacerX;
import com.helger.pdflayout.element.table.PLTableCell;
import com.helger.pdflayout.element.table.PLTableRow;
import com.helger.pdflayout.element.vbox.PLVBox;
import com.helger.pdflayout.element.vbox.PLVBoxRow;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.EValueUOMType;
import com.helger.pdflayout.spec.HeightSpec;
import com.helger.pdflayout.spec.MarginSpec;
import com.helger.pdflayout.spec.SizeSpec;
import com.helger.pdflayout.spec.WidthSpec;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PLTable
extends AbstractPLRenderableObject<PLTable>
implements IPLSplittableObject<PLTable, PLTable>,
IPLHasMargin<PLTable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PLTable.class);
    private final ICommonsList<WidthSpec> m_aWidths;
    private final EValueUOMType m_eCommonWidthType;
    private PLVBox m_aRows = (PLVBox)((PLVBox)new PLVBox().setVertSplittable(true)).setFullWidth(true);
    private MarginSpec m_aMargin = DEFAULT_MARGIN;

    @Deprecated
    @DevelopersNote(value="This ctor is only present to indicate if the varargs ctor would be used without parameters")
    public PLTable() {
        this((Iterable<? extends WidthSpec>)new CommonsArrayList());
    }

    public PLTable(WidthSpec ... widthSpecArray) {
        this((Iterable<? extends WidthSpec>)new CommonsArrayList((Object[])widthSpecArray));
    }

    public PLTable(@Nonnull @Nonempty Iterable<? extends WidthSpec> iterable) {
        ValueEnforcer.notEmptyNoNullValue(iterable, (String)"Widths");
        EValueUOMType eValueUOMType = null;
        boolean bl = false;
        for (WidthSpec widthSpec : iterable) {
            EValueUOMType eValueUOMType2 = widthSpec.getType();
            if (eValueUOMType2 == EValueUOMType.AUTO) {
                throw new IllegalArgumentException("Width type auto is not allowed for tables! Use type star instead!");
            }
            if (eValueUOMType == null) {
                eValueUOMType = eValueUOMType2;
                continue;
            }
            if (eValueUOMType2 == eValueUOMType) continue;
            bl = true;
        }
        this.m_aWidths = new CommonsArrayList(iterable);
        this.m_eCommonWidthType = bl ? null : eValueUOMType;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onAfterSetID() {
        this.m_aRows.setID(this.getID() + "-vbox");
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public PLTable setBasicDataFrom(@Nonnull PLTable pLTable) {
        super.setBasicDataFrom(pLTable);
        this.m_aRows.setBasicDataFrom(pLTable.m_aRows);
        this.setMargin(pLTable.m_aMargin);
        return this;
    }

    @Override
    @Nonnull
    public final MarginSpec getMargin() {
        return this.m_aMargin;
    }

    @Override
    @Nonnull
    public final PLTable setMargin(@Nonnull MarginSpec marginSpec) {
        ValueEnforcer.notNull((Object)marginSpec, (String)"Mergin");
        this.m_aMargin = marginSpec;
        return this;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<WidthSpec> getAllWidths() {
        return (ICommonsList)this.m_aWidths.getClone();
    }

    @Nonnegative
    public int getColumnCount() {
        return this.m_aWidths.size();
    }

    @Nonnull
    public PLTable setHeaderRowCount(@Nonnegative int n) {
        this.m_aRows.setHeaderRowCount(n);
        return this;
    }

    @Nonnegative
    public int getHeaderRowCount() {
        return this.m_aRows.getHeaderRowCount();
    }

    @Nonnull
    public PLTableRow addAndReturnRow(PLTableCell ... pLTableCellArray) {
        return this.addAndReturnRow((Iterable<? extends PLTableCell>)new CommonsArrayList((Object[])pLTableCellArray), this.m_aRows.getDefaultHeight());
    }

    @Nonnull
    public PLTableRow addAndReturnRow(@Nonnull Iterable<? extends PLTableCell> iterable) {
        return this.addAndReturnRow(iterable, this.m_aRows.getDefaultHeight());
    }

    @Nonnull
    public PLTableRow addAndReturnRow(@Nonnull Iterable<? extends PLTableCell> iterable, @Nonnull HeightSpec heightSpec) {
        ValueEnforcer.notNull(iterable, (String)"Cells");
        int n = 0;
        for (PLTableCell object : iterable) {
            if (object == null) {
                ++n;
                continue;
            }
            n += object.getColSpan();
        }
        if (n > this.m_aWidths.size()) {
            throw new IllegalArgumentException("More cells in row (" + n + ") than defined in the table (" + this.m_aWidths.size() + ")!");
        }
        PLTableRow pLTableRow = new PLTableRow();
        int n2 = 0;
        for (PLTableCell pLTableCell : iterable) {
            PLTableCell pLTableCell2 = pLTableCell != null ? pLTableCell : new PLTableCell(new PLSpacerX());
            int n3 = pLTableCell2.getColSpan();
            if (n3 == 1) {
                pLTableRow.addCell(pLTableCell2, (WidthSpec)this.m_aWidths.get(n2));
            } else {
                WidthSpec widthSpec;
                if (this.m_eCommonWidthType == null) {
                    throw new IllegalArgumentException("Since columns with different width types are used, 'colspan' must be 1");
                }
                List list = this.m_aWidths.subList(n2, n2 + n3);
                if (this.m_eCommonWidthType == EValueUOMType.STAR) {
                    widthSpec = WidthSpec.perc((float)n3 * 100.0f / (float)this.m_aWidths.size());
                } else {
                    float f = 0.0f;
                    for (WidthSpec widthSpec2 : list) {
                        f += widthSpec2.getValue();
                    }
                    widthSpec = new WidthSpec(this.m_eCommonWidthType, f);
                }
                pLTableRow.addCell(pLTableCell2, widthSpec);
            }
            n2 += n3;
        }
        this.addRow(pLTableRow, heightSpec);
        return pLTableRow;
    }

    @Nonnull
    public PLTable addRow(@Nonnull PLTableRow pLTableRow) {
        return this.addRow(pLTableRow, this.m_aRows.getDefaultHeight());
    }

    @Nonnull
    public PLTable addRow(@Nonnull PLTableRow pLTableRow, @Nonnull HeightSpec heightSpec) {
        ValueEnforcer.notNull((Object)pLTableRow, (String)"Row");
        this.m_aRows.addRow(pLTableRow, heightSpec);
        return this;
    }

    @Nonnull
    @Deprecated
    public PLTable addRow() {
        LOGGER.warn("You are calling the no-operation method 'PLTable.addRow()' - no row is added!!!");
        return this;
    }

    @Nonnull
    public PLTable addRow(PLTableCell ... pLTableCellArray) {
        return this.addRow((Iterable<? extends PLTableCell>)new CommonsArrayList((Object[])pLTableCellArray), this.m_aRows.getDefaultHeight());
    }

    @Nonnull
    public PLTable addRow(@Nonnull Iterable<? extends PLTableCell> iterable) {
        return this.addRow(iterable, this.m_aRows.getDefaultHeight());
    }

    @Nonnull
    public PLTable addRow(@Nonnull Iterable<? extends PLTableCell> iterable, @Nonnull HeightSpec heightSpec) {
        this.addAndReturnRow(iterable, heightSpec);
        return this;
    }

    public void forEachRow(@Nonnull Consumer<? super PLTableRow> consumer) {
        this.m_aRows.forEachRow((? super PLVBoxRow pLVBoxRow) -> consumer.accept((PLTableRow)pLVBoxRow.getElement()));
    }

    public void forEachRowByIndex(@Nonnull ObjIntConsumer<? super PLTableRow> objIntConsumer) {
        this.m_aRows.forEachRowByIndex((? super PLVBoxRow pLVBoxRow, int n) -> objIntConsumer.accept((PLTableRow)pLVBoxRow.getElement(), n));
    }

    public void forEachRow(int n, int n2, @Nonnull Consumer<? super PLTableRow> consumer) {
        this.forEachRowByIndex((pLTableRow, n3) -> {
            if (n3 >= n && n3 <= n2) {
                consumer.accept((PLTableRow)pLTableRow);
            }
        });
    }

    public void forEachRow(int n, int n2, @Nonnull ObjIntConsumer<? super PLTableRow> objIntConsumer) {
        this.forEachRowByIndex((pLTableRow, n3) -> {
            if (n3 >= n && n3 <= n2) {
                objIntConsumer.accept((PLTableRow)pLTableRow, n3);
            }
        });
    }

    @Nonnegative
    public int getRowCount() {
        return this.m_aRows.getRowCount();
    }

    public void forEachCell(@Nonnull Consumer<? super PLTableCell> consumer) {
        this.forEachRow(pLTableRow -> pLTableRow.forEachCell(consumer));
    }

    @Nullable
    public PLTableRow getRowAtIndex(@Nonnegative int n) {
        PLVBoxRow pLVBoxRow = this.m_aRows.getRowAtIndex(n);
        return pLVBoxRow == null ? null : (PLTableRow)pLVBoxRow.getElement();
    }

    @Nullable
    public PLTableCell getCellAtIndex(@Nonnegative int n, @Nonnegative int n2) {
        PLTableRow pLTableRow = this.getRowAtIndex(n);
        return pLTableRow == null ? null : pLTableRow.getCellAtIndex(n2);
    }

    @Override
    @Nonnull
    public EChange visit(@Nonnull IPLVisitor iPLVisitor) throws IOException {
        EChange eChange = super.visit(iPLVisitor);
        return eChange.or((IChangeIndicator)this.m_aRows.visit(iPLVisitor));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected SizeSpec onPrepare(@Nonnull PreparationContext preparationContext) {
        float f = preparationContext.getAvailableWidth() - this.getOutlineXSum();
        float f2 = preparationContext.getAvailableHeight() - this.getOutlineYSum();
        PreparationContext preparationContext2 = new PreparationContext(preparationContext.getGlobalContext(), f, f2);
        SizeSpec sizeSpec = this.m_aRows.prepare(preparationContext2);
        return sizeSpec.plus(this.m_aRows.getOutlineXSum(), this.m_aRows.getOutlineYSum());
    }

    @Override
    protected void onMarkAsNotPrepared() {
        this.m_aRows.internalMarkAsNotPrepared();
    }

    @Override
    public final boolean isVertSplittable() {
        return this.m_aRows.isVertSplittable();
    }

    @Override
    @Nonnull
    public final PLTable setVertSplittable(boolean bl) {
        this.m_aRows.setVertSplittable(bl);
        return this;
    }

    @Override
    @Nonnull
    public PLTable internalCreateNewVertSplitObject(@Nonnull PLTable pLTable) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public PLSplitResult splitElementVert(float f, float f2) {
        PLSplitResult pLSplitResult;
        float f3 = f2;
        if (PLDebugLog.isDebugSplit()) {
            PLDebugLog.debugSplit(this, "Trying to split " + this.m_aRows.getDebugID() + " into pieces for available width " + f + " and height " + f3);
        }
        if ((pLSplitResult = this.m_aRows.splitElementVert(f, f3)) == null) {
            return pLSplitResult;
        }
        PLTable pLTable = new PLTable((Iterable<? extends WidthSpec>)this.m_aWidths);
        pLTable.setID(this.getID() + "-1");
        pLTable.setBasicDataFrom(this);
        pLTable.internalMarkAsPrepared(pLSplitResult.getFirstElement().getSize());
        pLTable.m_aRows = (PLVBox)pLSplitResult.getFirstElement().getElement();
        PLTable pLTable2 = new PLTable((Iterable<? extends WidthSpec>)this.m_aWidths);
        pLTable2.setID(this.getID() + "-2");
        pLTable2.setBasicDataFrom(this);
        pLTable2.internalMarkAsPrepared(pLSplitResult.getSecondElement().getSize());
        pLTable2.m_aRows = (PLVBox)pLSplitResult.getSecondElement().getElement();
        return new PLSplitResult(new PLElementWithSize(pLTable, pLSplitResult.getFirstElement().getSize()), new PLElementWithSize(pLTable2, pLSplitResult.getSecondElement().getSize()));
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        PageRenderContext pageRenderContext2 = new PageRenderContext(pageRenderContext, pageRenderContext.getStartLeft() + this.getMarginLeft(), pageRenderContext.getStartTop() - this.getMarginTop(), pageRenderContext.getWidth() - this.getMarginXSum(), pageRenderContext.getHeight() - this.getMarginYSum());
        this.m_aRows.render(pageRenderContext2);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Rows", (Object)this.m_aRows).append("Width", this.m_aWidths).append("WidthType", (Enum)this.m_eCommonWidthType).append("Margin", (Object)this.m_aMargin).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PLTable createWithPercentage(float ... fArray) {
        ValueEnforcer.notEmpty((float[])fArray, (String)"Percentages");
        CommonsArrayList commonsArrayList = new CommonsArrayList(fArray.length);
        for (float f : fArray) {
            commonsArrayList.add((Object)WidthSpec.perc(f));
        }
        return new PLTable((Iterable<? extends WidthSpec>)commonsArrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static PLTable createWithEvenlySizedColumns(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"ColumnCount");
        CommonsArrayList commonsArrayList = new CommonsArrayList(n);
        for (int i = 0; i < n; ++i) {
            commonsArrayList.add((Object)WidthSpec.star());
        }
        return new PLTable((Iterable<? extends WidthSpec>)commonsArrayList);
    }
}

