/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.pdfbox;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.pdfbox.PDPageContentStreamExt;
import com.helger.pdflayout.spec.FontSpec;
import com.helger.pdflayout.spec.LineDashPatternSpec;
import com.helger.pdflayout.spec.LoadedFont;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PDPageContentStreamWithCache {
    private final PDDocument m_aDocument;
    private final PDPage m_aPage;
    private final PDPageContentStreamExt m_aStream;
    private LoadedFont m_aLastUsedLoadedFont;
    private float m_fLastUsedFontSize;
    private PLColor m_aLastUsedStrokingColor = PLColor.BLACK;
    private PLColor m_aLastUsedNonStrokingColor = PLColor.BLACK;
    private LineDashPatternSpec m_aLastUsedLineDashPattern = LineDashPatternSpec.SOLID;
    private float m_fLastUsedLineWidth;

    public PDPageContentStreamWithCache(@Nonnull PDDocument pDDocument, @Nonnull PDPage pDPage, @Nonnull PDPageContentStream.AppendMode appendMode, boolean bl) throws IOException {
        this.m_aDocument = pDDocument;
        this.m_aPage = pDPage;
        this.m_aStream = new PDPageContentStreamExt(pDDocument, pDPage, appendMode, bl);
    }

    @Nonnull
    public final PDDocument getDocument() {
        return this.m_aDocument;
    }

    @Nonnull
    public final PDPage getPage() {
        return this.m_aPage;
    }

    @Nonnull
    public final PDPageContentStreamExt getContentStream() {
        return this.m_aStream;
    }

    public void setFont(@Nonnull LoadedFont loadedFont, @Nonnull FontSpec fontSpec) throws IOException {
        ValueEnforcer.notNull((Object)loadedFont, (String)"Font");
        float f = fontSpec.getFontSize();
        if (this.m_aLastUsedLoadedFont == null || !loadedFont.equals(this.m_aLastUsedLoadedFont) || !EqualsHelper.equals((float)f, (float)this.m_fLastUsedFontSize)) {
            this.m_aStream.setFont(loadedFont.getFont(), f);
            this.m_aLastUsedLoadedFont = loadedFont;
            this.m_fLastUsedFontSize = f;
        }
        this.setNonStrokingColor(fontSpec.getColor());
    }

    public void setStrokingColor(@Nonnull PLColor pLColor) throws IOException {
        ValueEnforcer.notNull((Object)pLColor, (String)"Color");
        if (!this.m_aLastUsedStrokingColor.equals(pLColor)) {
            this.m_aStream.setStrokingColor(pLColor);
            this.m_aLastUsedStrokingColor = pLColor;
        }
    }

    @Nonnull
    public PLColor getLastUsedStrokingColor() {
        return this.m_aLastUsedStrokingColor;
    }

    public void setNonStrokingColor(@Nonnull PLColor pLColor) throws IOException {
        ValueEnforcer.notNull((Object)pLColor, (String)"Color");
        if (!this.m_aLastUsedNonStrokingColor.equals(pLColor)) {
            this.m_aStream.setNonStrokingColor(pLColor);
            this.m_aLastUsedNonStrokingColor = pLColor;
        }
    }

    @Nonnull
    public PLColor getLastUsedNonStrokingColor() {
        return this.m_aLastUsedNonStrokingColor;
    }

    public void setLineDashPattern(@Nonnull LineDashPatternSpec lineDashPatternSpec) throws IOException {
        ValueEnforcer.notNull((Object)lineDashPatternSpec, (String)"LineDashPattern");
        if (!this.m_aLastUsedLineDashPattern.equals(lineDashPatternSpec)) {
            this.m_aStream.setLineDashPattern(lineDashPatternSpec.getPattern(), lineDashPatternSpec.getPhase());
            this.m_aLastUsedLineDashPattern = lineDashPatternSpec;
        }
    }

    @Nonnull
    public LineDashPatternSpec getLastUsedLineDashPattern() {
        return this.m_aLastUsedLineDashPattern;
    }

    public void setLineWidth(float f) throws IOException {
        if (f >= 0.0f && !EqualsHelper.equals((float)this.m_fLastUsedLineWidth, (float)f)) {
            this.m_aStream.setLineWidth(f);
            this.m_fLastUsedLineWidth = f;
        }
    }

    public float getLastUsedLineWidth() {
        return this.m_fLastUsedLineWidth;
    }

    public void moveTextPositionByAmount(float f, float f2) throws IOException {
        if (f != 0.0f || f2 != 0.0f) {
            this.m_aStream.newLineAtOffset(f, f2);
        }
    }

    public void stroke() throws IOException {
        this.m_aStream.stroke();
    }

    public void fill() throws IOException {
        this.m_aStream.fill();
    }

    public void addRect(float f, float f2, float f3, float f4) throws IOException {
        this.m_aStream.addRect(f, f2, f3, f4);
    }

    public void drawLine(float f, float f2, float f3, float f4) throws IOException {
        this.m_aStream.moveTo(f, f2);
        this.m_aStream.lineTo(f3, f4);
        this.stroke();
    }

    public void fillRect(float f, float f2, float f3, float f4) throws IOException {
        this.addRect(f, f2, f3, f4);
        this.fill();
    }

    public void beginText() throws IOException {
        this.m_aStream.beginText();
    }

    public void endText() throws IOException {
        this.m_aStream.endText();
    }

    public void setCharacterSpacing(float f) throws IOException {
        this.m_aStream.setCharacterSpacing(f);
    }

    public void drawString(String string) throws IOException {
        byte[] byArray = this.m_aLastUsedLoadedFont.getEncodedForPageContentStream(string);
        COSWriter.writeString((byte[])byArray, (OutputStream)this.m_aStream.getOutput());
        this.m_aStream.write(32);
        this.m_aStream.writeOperator(84, 106);
    }

    public void drawXObject(PDImageXObject pDImageXObject, float f, float f2, float f3, float f4) throws IOException {
        this.m_aStream.drawImage(pDImageXObject, f, f2, f3, f4);
    }

    public void close() throws IOException {
        this.m_aStream.close();
    }
}

