/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.render;

import com.helger.pdflayout.base.IPLElement;
import com.helger.pdflayout.base.IPLHasBorder;
import com.helger.pdflayout.base.IPLHasFillColor;
import com.helger.pdflayout.base.IPLHasMargin;
import com.helger.pdflayout.base.IPLObject;
import com.helger.pdflayout.base.PLColor;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.debug.PLDebugRender;
import com.helger.pdflayout.pdfbox.PDPageContentStreamWithCache;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.spec.BorderSpec;
import com.helger.pdflayout.spec.BorderStyleSpec;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PLRenderHelper {
    private PLRenderHelper() {
    }

    public static void renderBorder(@Nonnull IPLObject<?> iPLObject, @Nonnull PDPageContentStreamWithCache pDPageContentStreamWithCache, float f, float f2, float f3, float f4, @Nonnull BorderSpec borderSpec) throws IOException {
        float f5 = f + f3;
        float f6 = f2 - f4;
        if (borderSpec.hasAllBorders() && borderSpec.areAllBordersEqual()) {
            BorderStyleSpec borderStyleSpec = borderSpec.getLeft();
            float f7 = borderStyleSpec.getLineWidth();
            float f8 = f7 / 2.0f;
            if (PLDebugLog.isDebugRender()) {
                PLDebugLog.debugRender(iPLObject, "Border around " + PLDebugLog.getXYWH(f, f2, f3, f4) + " with line width " + f7);
            }
            pDPageContentStreamWithCache.setStrokingColor(borderStyleSpec.getColor());
            pDPageContentStreamWithCache.setLineDashPattern(borderStyleSpec.getLineDashPattern());
            pDPageContentStreamWithCache.setLineWidth(f7);
            pDPageContentStreamWithCache.addRect(f + f8, f6 + f8, f3 - f7, f4 - f7);
            pDPageContentStreamWithCache.stroke();
        } else if (borderSpec.hasAnyBorder()) {
            float f9;
            float f10;
            BorderStyleSpec borderStyleSpec = borderSpec.getTop();
            BorderStyleSpec borderStyleSpec2 = borderSpec.getRight();
            BorderStyleSpec borderStyleSpec3 = borderSpec.getBottom();
            BorderStyleSpec borderStyleSpec4 = borderSpec.getLeft();
            float f11 = borderStyleSpec == null ? 0.0f : borderStyleSpec.getLineWidth();
            float f12 = borderStyleSpec2 == null ? 0.0f : borderStyleSpec2.getLineWidth();
            float f13 = borderStyleSpec3 == null ? 0.0f : borderStyleSpec3.getLineWidth();
            float f14 = f10 = borderStyleSpec4 == null ? 0.0f : borderStyleSpec4.getLineWidth();
            if (borderStyleSpec != null) {
                if (PLDebugLog.isDebugRender()) {
                    PLDebugLog.debugRender(iPLObject, "Border top " + PLDebugLog.getXYWH(f, f2, f3, 0.0f) + " with line width " + f11);
                }
                f9 = f11 / 2.0f;
                pDPageContentStreamWithCache.setStrokingColor(borderStyleSpec.getColor());
                pDPageContentStreamWithCache.setLineDashPattern(borderStyleSpec.getLineDashPattern());
                pDPageContentStreamWithCache.setLineWidth(f11);
                pDPageContentStreamWithCache.drawLine(f, f2 - f9, f5 - f12, f2 - f9);
            }
            if (borderStyleSpec2 != null) {
                if (PLDebugLog.isDebugRender()) {
                    PLDebugLog.debugRender(iPLObject, "Border right " + PLDebugLog.getXYWH(f5, f2, 0.0f, f4) + " with line width " + f12);
                }
                f9 = f12 / 2.0f;
                pDPageContentStreamWithCache.setStrokingColor(borderStyleSpec2.getColor());
                pDPageContentStreamWithCache.setLineDashPattern(borderStyleSpec2.getLineDashPattern());
                pDPageContentStreamWithCache.setLineWidth(f12);
                pDPageContentStreamWithCache.drawLine(f5 - f9, f2, f5 - f9, f6 + f13);
            }
            if (borderStyleSpec3 != null) {
                if (PLDebugLog.isDebugRender()) {
                    PLDebugLog.debugRender(iPLObject, "Border bottom " + PLDebugLog.getXYWH(f, f6, f3, 0.0f) + " with line width " + f13);
                }
                f9 = f13 / 2.0f;
                pDPageContentStreamWithCache.setStrokingColor(borderStyleSpec3.getColor());
                pDPageContentStreamWithCache.setLineDashPattern(borderStyleSpec3.getLineDashPattern());
                pDPageContentStreamWithCache.setLineWidth(f13);
                pDPageContentStreamWithCache.drawLine(f + f10, f6 + f9, f5, f6 + f9);
            }
            if (borderStyleSpec4 != null) {
                if (PLDebugLog.isDebugRender()) {
                    PLDebugLog.debugRender(iPLObject, "Border left " + PLDebugLog.getXYWH(f, f2, 0.0f, f4) + " with line width " + f10);
                }
                f9 = f10 / 2.0f;
                pDPageContentStreamWithCache.setStrokingColor(borderStyleSpec4.getColor());
                pDPageContentStreamWithCache.setLineDashPattern(borderStyleSpec4.getLineDashPattern());
                pDPageContentStreamWithCache.setLineWidth(f10);
                pDPageContentStreamWithCache.drawLine(f + f9, f2 - f11, f + f9, f6);
            }
            pDPageContentStreamWithCache.stroke();
        }
    }

    public static <T extends IPLElement<T>> void fillAndRenderBorder(@Nonnull T t, @Nonnull PageRenderContext pageRenderContext, float f, float f2) throws IOException {
        float f3 = pageRenderContext.getStartLeft() + t.getMarginLeft() + f;
        float f4 = pageRenderContext.getStartTop() - t.getMarginTop() - f2;
        float f5 = t.getRenderWidth() + t.getBorderXSumWidth() + t.getPaddingXSum();
        float f6 = t.getRenderHeight() + t.getBorderYSumWidth() + t.getPaddingYSum();
        PLRenderHelper.fillAndRenderBorder(t, f3, f4, f5, f6, pageRenderContext.getContentStream());
    }

    public static <T extends IPLObject<T> & IPLHasFillColor<T>> void fillAndRenderBorder(@Nonnull T t, float f, float f2, float f3, float f4, @Nonnull PDPageContentStreamWithCache pDPageContentStreamWithCache) throws IOException {
        BorderSpec borderSpec;
        PLColor pLColor;
        boolean bl = PLDebugRender.isDebugRender();
        if (bl && (pLColor = PLDebugRender.getDebugOutlineColor(t)) != null) {
            pDPageContentStreamWithCache.setNonStrokingColor(pLColor);
            pDPageContentStreamWithCache.fillRect(f - ((IPLHasMargin)t).getMarginLeft(), f2 - f4 - ((IPLHasMargin)t).getMarginBottom(), f3 + ((IPLHasMargin)t).getMarginXSum(), f4 + ((IPLHasMargin)t).getMarginYSum());
        }
        if ((pLColor = ((IPLHasFillColor<T>)t).getFillColor()) != null) {
            pDPageContentStreamWithCache.setNonStrokingColor(pLColor);
            pDPageContentStreamWithCache.fillRect(f, f2 - f4, f3, f4);
        }
        if (bl && (borderSpec = new BorderSpec(PLDebugRender.getDebugBorder(t))).hasAnyBorder()) {
            PLRenderHelper.renderBorder(t, pDPageContentStreamWithCache, f, f2, f3, f4, borderSpec);
        }
        if ((borderSpec = ((IPLHasBorder)t).getBorder()).hasAnyBorder()) {
            PLRenderHelper.renderBorder(t, pDPageContentStreamWithCache, f, f2, f3, f4, borderSpec);
        }
    }
}

