/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.render;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.pdfbox.PDPageContentStreamWithCache;
import com.helger.pdflayout.render.ERenderingElementType;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pdfbox.pdmodel.PDDocument;

@NotThreadSafe
public final class PageRenderContext {
    private final ERenderingElementType m_eElementType;
    private final PDPageContentStreamWithCache m_aCS;
    private final float m_fStartLeft;
    private final float m_fStartTop;
    private final float m_fWidth;
    private final float m_fHeight;

    public PageRenderContext(@Nonnull PageRenderContext pageRenderContext, float f, float f2, float f3, float f4) {
        this(pageRenderContext.getElementType(), pageRenderContext.getContentStream(), f, f2, f3, f4);
    }

    public PageRenderContext(@Nonnull ERenderingElementType eRenderingElementType, @Nonnull PDPageContentStreamWithCache pDPageContentStreamWithCache, float f, float f2, float f3, float f4) {
        ValueEnforcer.notNull((Object)((Object)eRenderingElementType), (String)"ElementType");
        ValueEnforcer.notNull((Object)pDPageContentStreamWithCache, (String)"ContentStream");
        ValueEnforcer.isGE0((float)f, (String)"StartLeft");
        ValueEnforcer.isGE0((float)f2, (String)"StartTop");
        ValueEnforcer.isGE0((float)f3, (String)"Width");
        ValueEnforcer.isGE0((float)f4, (String)"Height");
        this.m_eElementType = eRenderingElementType;
        this.m_aCS = pDPageContentStreamWithCache;
        this.m_fStartLeft = f;
        this.m_fStartTop = f2;
        this.m_fWidth = f3;
        this.m_fHeight = f4;
    }

    @Nonnull
    public ERenderingElementType getElementType() {
        return this.m_eElementType;
    }

    @Nonnull
    public PDPageContentStreamWithCache getContentStream() {
        return this.m_aCS;
    }

    @Nonnull
    public PDDocument getDocument() {
        return this.m_aCS.getDocument();
    }

    public float getStartLeft() {
        return this.m_fStartLeft;
    }

    public float getStartTop() {
        return this.m_fStartTop;
    }

    public float getWidth() {
        return this.m_fWidth;
    }

    public float getHeight() {
        return this.m_fHeight;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ElementType", (Enum)this.m_eElementType).append("ContentStream", (Object)this.m_aCS).append("StartLeft", this.m_fStartLeft).append("StartTop", this.m_fStartTop).append("Width", this.m_fWidth).append("Height", this.m_fHeight).getToString();
    }
}

