/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.font.api.IFontResource;
import com.helger.font.api.IHasFontResource;
import com.helger.pdflayout.spec.IPreloadFontResolver;
import com.helger.pdflayout.spec.PreloadFont;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PreloadFontManager
implements IPreloadFontResolver {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, PreloadFont> m_aMap = new CommonsHashMap();

    public PreloadFontManager() {
        this(true);
    }

    public PreloadFontManager(boolean bl) {
        if (bl) {
            this.addPreloadFont(PreloadFont.REGULAR);
            this.addPreloadFont(PreloadFont.REGULAR_BOLD);
            this.addPreloadFont(PreloadFont.REGULAR_ITALIC);
            this.addPreloadFont(PreloadFont.REGULAR_BOLD_ITALIC);
            this.addPreloadFont(PreloadFont.MONOSPACE);
            this.addPreloadFont(PreloadFont.MONOSPACE_BOLD);
            this.addPreloadFont(PreloadFont.MONOSPACE_ITALIC);
            this.addPreloadFont(PreloadFont.MONOSPACE_BOLD_ITALIC);
            this.addPreloadFont(PreloadFont.TIMES);
            this.addPreloadFont(PreloadFont.TIMES_BOLD);
            this.addPreloadFont(PreloadFont.TIMES_ITALIC);
            this.addPreloadFont(PreloadFont.TIMES_BOLD_ITALIC);
            this.addPreloadFont(PreloadFont.SYMBOL);
            this.addPreloadFont(PreloadFont.ZAPF_DINGBATS);
        }
    }

    public void addPreloadFont(@Nonnull PreloadFont preloadFont) {
        ValueEnforcer.notNull((Object)preloadFont, (String)"PreloadFont");
        String string = preloadFont.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)string)) {
                throw new IllegalArgumentException("The PreloadFont  " + preloadFont + " is already contained!");
            }
            this.m_aMap.put((Object)string, (Object)preloadFont);
        });
    }

    @Nonnull
    public PreloadFont getOrAddEmbeddingPreloadFont(@Nonnull IHasFontResource iHasFontResource) {
        ValueEnforcer.notNull((Object)iHasFontResource, (String)"FontResProvider");
        return this.getOrAddEmbeddingPreloadFont(iHasFontResource.getFontResource());
    }

    @Nonnull
    public PreloadFont getOrAddEmbeddingPreloadFont(@Nonnull IFontResource iFontResource) {
        ValueEnforcer.notNull((Object)iFontResource, (String)"FontRes");
        PreloadFont preloadFont = this.getPreloadFontOfID(iFontResource);
        if (preloadFont == null) {
            preloadFont = PreloadFont.createEmbedding(iFontResource);
            this.addPreloadFont(preloadFont);
        }
        return preloadFont;
    }

    @Override
    @Nullable
    public PreloadFont getPreloadFontOfID(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return (PreloadFont)this.m_aRWLock.readLockedGet(() -> (PreloadFont)this.m_aMap.get((Object)string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PreloadFont> getAllPreloadFonts() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfValues());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PreloadFont> getAllPreloadFonts(@Nullable Predicate<? super PreloadFont> predicate) {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aMap.copyOfValues(predicate));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }
}

