
package com.helger.regrep.lcm;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for mode.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="mode">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}NCName">
 *     <enumeration value="CreateOrReplace"/>
 *     <enumeration value="CreateOrVersion"/>
 *     <enumeration value="CreateOnly"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "mode")
@XmlEnum
@CodingStyleguideUnaware
public enum Mode {

    @XmlEnumValue("CreateOrReplace")
    CREATE_OR_REPLACE("CreateOrReplace"),
    @XmlEnumValue("CreateOrVersion")
    CREATE_OR_VERSION("CreateOrVersion"),
    @XmlEnumValue("CreateOnly")
    CREATE_ONLY("CreateOnly");
    private final String value;

    Mode(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static Mode fromValue(String v) {
        for (Mode c: Mode.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
