
package com.helger.regrep.lcm;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.QueryExpressionType;
import com.helger.regrep.rim.ValueType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for UpdateActionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="UpdateActionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ValueHolder" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ValueType" minOccurs="0"/>
 *         <element name="Selector" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}QueryExpressionType"/>
 *       </sequence>
 *       <attribute name="mode" use="required">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}NCName">
 *             <enumeration value="Insert"/>
 *             <enumeration value="Update"/>
 *             <enumeration value="Delete"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UpdateActionType", propOrder = {
    "valueHolder",
    "selector"
})
@CodingStyleguideUnaware
public class UpdateActionType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ValueHolder")
    private ValueType valueHolder;
    @XmlElement(name = "Selector", required = true)
    private QueryExpressionType selector;
    @XmlAttribute(name = "mode", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    private String mode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public UpdateActionType() {
    }

    /**
     * Gets the value of the valueHolder property.
     * 
     * @return
     *     possible object is
     *     {@link ValueType }
     *     
     */
    @Nullable
    public ValueType getValueHolder() {
        return valueHolder;
    }

    /**
     * Sets the value of the valueHolder property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValueType }
     *     
     */
    public void setValueHolder(
        @Nullable
        ValueType value) {
        this.valueHolder = value;
    }

    /**
     * Gets the value of the selector property.
     * 
     * @return
     *     possible object is
     *     {@link QueryExpressionType }
     *     
     */
    @Nullable
    public QueryExpressionType getSelector() {
        return selector;
    }

    /**
     * Sets the value of the selector property.
     * 
     * @param value
     *     allowed object is
     *     {@link QueryExpressionType }
     *     
     */
    public void setSelector(
        @Nullable
        QueryExpressionType value) {
        this.selector = value;
    }

    /**
     * Gets the value of the mode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getMode() {
        return mode;
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMode(
        @Nullable
        String value) {
        this.mode = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final UpdateActionType rhs = ((UpdateActionType) o);
        if (!EqualsHelper.equals(mode, rhs.mode)) {
            return false;
        }
        if (!EqualsHelper.equals(selector, rhs.selector)) {
            return false;
        }
        if (!EqualsHelper.equals(valueHolder, rhs.valueHolder)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(mode).append(selector).append(valueHolder).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("mode", mode).append("selector", selector).append("valueHolder", valueHolder).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        UpdateActionType ret) {
        ret.mode = mode;
        ret.selector = ((selector == null)?null:selector.clone());
        ret.valueHolder = ((valueHolder == null)?null:valueHolder.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public UpdateActionType clone() {
        UpdateActionType ret = new UpdateActionType();
        cloneTo(ret);
        return ret;
    }

}
