
package com.helger.regrep.lcm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.ObjectRefListType;
import com.helger.regrep.rim.QueryType;
import com.helger.regrep.rs.RegistryRequestType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType>
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rs:4.0}RegistryRequestType">
 *       <sequence>
 *         <element name="Query" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}QueryType" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ObjectRefList" minOccurs="0"/>
 *         <element name="UpdateAction" type="{urn:oasis:names:tc:ebxml-regrep:xsd:lcm:4.0}UpdateActionType" maxOccurs="unbounded"/>
 *       </sequence>
 *       <attribute name="checkReferences" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="mode" type="{urn:oasis:names:tc:ebxml-regrep:xsd:lcm:4.0}mode" default="CreateOrReplace" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "query",
    "objectRefList",
    "updateAction"
})
@XmlRootElement(name = "UpdateObjectsRequest")
@CodingStyleguideUnaware
public class UpdateObjectsRequest
    extends RegistryRequestType
{

    @XmlElement(name = "Query")
    private QueryType query;
    @XmlElement(name = "ObjectRefList", namespace = "urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0")
    private ObjectRefListType objectRefList;
    @XmlElement(name = "UpdateAction", required = true)
    private List<UpdateActionType> updateAction;
    @XmlAttribute(name = "checkReferences")
    private Boolean checkReferences;
    @XmlAttribute(name = "mode")
    private Mode mode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public UpdateObjectsRequest() {
    }

    /**
     * Gets the value of the query property.
     * 
     * @return
     *     possible object is
     *     {@link QueryType }
     *     
     */
    @Nullable
    public QueryType getQuery() {
        return query;
    }

    /**
     * Sets the value of the query property.
     * 
     * @param value
     *     allowed object is
     *     {@link QueryType }
     *     
     */
    public void setQuery(
        @Nullable
        QueryType value) {
        this.query = value;
    }

    /**
     * Gets the value of the objectRefList property.
     * 
     * @return
     *     possible object is
     *     {@link ObjectRefListType }
     *     
     */
    @Nullable
    public ObjectRefListType getObjectRefList() {
        return objectRefList;
    }

    /**
     * Sets the value of the objectRefList property.
     * 
     * @param value
     *     allowed object is
     *     {@link ObjectRefListType }
     *     
     */
    public void setObjectRefList(
        @Nullable
        ObjectRefListType value) {
        this.objectRefList = value;
    }

    /**
     * Gets the value of the updateAction property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the updateAction property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUpdateAction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UpdateActionType }
     * 
     * 
     * @return
     *     The value of the updateAction property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<UpdateActionType> getUpdateAction() {
        if (updateAction == null) {
            updateAction = new ArrayList<>();
        }
        return this.updateAction;
    }

    /**
     * Gets the value of the checkReferences property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCheckReferences() {
        if (checkReferences == null) {
            return false;
        } else {
            return checkReferences;
        }
    }

    /**
     * Sets the value of the checkReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCheckReferences(
        @Nullable
        Boolean value) {
        this.checkReferences = value;
    }

    /**
     * Gets the value of the mode property.
     * 
     * @return
     *     possible object is
     *     {@link Mode }
     *     
     */
    @Nullable
    public Mode getMode() {
        if (mode == null) {
            return Mode.CREATE_OR_REPLACE;
        } else {
            return mode;
        }
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link Mode }
     *     
     */
    public void setMode(
        @Nullable
        Mode value) {
        this.mode = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final UpdateObjectsRequest rhs = ((UpdateObjectsRequest) o);
        if (!EqualsHelper.equals(checkReferences, rhs.checkReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(mode, rhs.mode)) {
            return false;
        }
        if (!EqualsHelper.equals(objectRefList, rhs.objectRefList)) {
            return false;
        }
        if (!EqualsHelper.equals(query, rhs.query)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(updateAction, rhs.updateAction)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(checkReferences).append(mode).append(objectRefList).append(query).append(updateAction).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("checkReferences", checkReferences).append("mode", mode).append("objectRefList", objectRefList).append("query", query).append("updateAction", updateAction).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUpdateAction(
        @Nullable
        final List<UpdateActionType> aList) {
        updateAction = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUpdateActionEntries() {
        return (!getUpdateAction().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUpdateActionEntries() {
        return getUpdateAction().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUpdateActionCount() {
        return getUpdateAction().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public UpdateActionType getUpdateActionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUpdateAction().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUpdateAction(
        @Nonnull
        final UpdateActionType elem) {
        getUpdateAction().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        UpdateObjectsRequest ret) {
        super.cloneTo(ret);
        ret.checkReferences = checkReferences;
        ret.mode = mode;
        ret.objectRefList = ((objectRefList == null)?null:objectRefList.clone());
        ret.query = ((query == null)?null:query.clone());
        if (updateAction == null) {
            ret.updateAction = null;
        } else {
            List<UpdateActionType> retUpdateAction = new ArrayList<>();
            for (UpdateActionType aItem: getUpdateAction()) {
                retUpdateAction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.updateAction = retUpdateAction;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public UpdateObjectsRequest clone() {
        UpdateObjectsRequest ret = new UpdateObjectsRequest();
        cloneTo(ret);
        return ret;
    }

}
