
package com.helger.regrep.rim;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * Represents an action on a set of affected RegistryObjects within an AuditableEvent.
 * 
 * <p>Java class for ActionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ActionType">
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExtensibleObjectType">
 *       <sequence>
 *         <element name="AffectedObjects" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}RegistryObjectListType" minOccurs="0"/>
 *         <element name="AffectedObjectRefs" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ObjectRefListType" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="eventType" use="required" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ActionType", propOrder = {
    "affectedObjects",
    "affectedObjectRefs"
})
@CodingStyleguideUnaware
public class ActionType
    extends ExtensibleObjectType
{

    @XmlElement(name = "AffectedObjects")
    private RegistryObjectListType affectedObjects;
    @XmlElement(name = "AffectedObjectRefs")
    private ObjectRefListType affectedObjectRefs;
    @XmlAttribute(name = "eventType", required = true)
    private String eventType;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ActionType() {
    }

    /**
     * Gets the value of the affectedObjects property.
     * 
     * @return
     *     possible object is
     *     {@link RegistryObjectListType }
     *     
     */
    @Nullable
    public RegistryObjectListType getAffectedObjects() {
        return affectedObjects;
    }

    /**
     * Sets the value of the affectedObjects property.
     * 
     * @param value
     *     allowed object is
     *     {@link RegistryObjectListType }
     *     
     */
    public void setAffectedObjects(
        @Nullable
        RegistryObjectListType value) {
        this.affectedObjects = value;
    }

    /**
     * Gets the value of the affectedObjectRefs property.
     * 
     * @return
     *     possible object is
     *     {@link ObjectRefListType }
     *     
     */
    @Nullable
    public ObjectRefListType getAffectedObjectRefs() {
        return affectedObjectRefs;
    }

    /**
     * Sets the value of the affectedObjectRefs property.
     * 
     * @param value
     *     allowed object is
     *     {@link ObjectRefListType }
     *     
     */
    public void setAffectedObjectRefs(
        @Nullable
        ObjectRefListType value) {
        this.affectedObjectRefs = value;
    }

    /**
     * Gets the value of the eventType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getEventType() {
        return eventType;
    }

    /**
     * Sets the value of the eventType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEventType(
        @Nullable
        String value) {
        this.eventType = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final ActionType rhs = ((ActionType) o);
        if (!EqualsHelper.equals(affectedObjectRefs, rhs.affectedObjectRefs)) {
            return false;
        }
        if (!EqualsHelper.equals(affectedObjects, rhs.affectedObjects)) {
            return false;
        }
        if (!EqualsHelper.equals(eventType, rhs.eventType)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(affectedObjectRefs).append(affectedObjects).append(eventType).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("affectedObjectRefs", affectedObjectRefs).append("affectedObjects", affectedObjects).append("eventType", eventType).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ActionType ret) {
        super.cloneTo(ret);
        ret.affectedObjectRefs = ((affectedObjectRefs == null)?null:affectedObjectRefs.clone());
        ret.affectedObjects = ((affectedObjects == null)?null:affectedObjects.clone());
        ret.eventType = eventType;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ActionType clone() {
        ActionType ret = new ActionType();
        cloneTo(ret);
        return ret;
    }

}
