
package com.helger.regrep.rim;

import javax.annotation.Nonnull;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *         Models the familiar “PostIt attached to papers” metaphor.
 *         Used to attach comments to Register during registration procedures, may be used to comment on any RegistryObject.
 *         Implemented as a sub-type of ExtrinsicObjectType.
 *         If comment is small it is specified in description field.
 *         If comment is large or needs formatting, images etc. then it is specified in the RepositoryItem as a document.
 *         Adding a comment to a RegistryObject done by defining a “HasComment” Association with an ExtrinsicObject with objectType “Comment”.
 *       
 * 
 * <p>Java class for CommentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="CommentType">
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExtrinsicObjectType">
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CommentType")
@CodingStyleguideUnaware
public class CommentType
    extends ExtrinsicObjectType
{


    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public CommentType() {
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        return super.equals(o);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CommentType ret) {
        super.cloneTo(ret);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CommentType clone() {
        CommentType ret = new CommentType();
        cloneTo(ret);
        return ret;
    }

}
