
package com.helger.regrep.rim;

import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 *         A specialized ValueType that may be used as a container for a dateTime value.
 *       
 * 
 * <p>Java class for DateTimeValueType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="DateTimeValueType">
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ValueType">
 *       <sequence>
 *         <element name="Value" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-offset-dt-extension</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DateTimeValueType", propOrder = {
    "value"
})
@CodingStyleguideUnaware
public class DateTimeValueType
    extends ValueType
{

    @XmlElement(name = "Value", type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime value;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public DateTimeValueType() {
    }

    /**
     * Constructor for value of type XMLOffsetDateTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public DateTimeValueType(
        @Nullable
        final XMLOffsetDateTime valueParam) {
        setValue(valueParam);
    }

    /**
     * Constructor for value of type LocalDateTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public DateTimeValueType(
        @Nullable
        final LocalDateTime valueParam) {
        setValue(valueParam);
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(
        @Nullable
        XMLOffsetDateTime value) {
        this.value = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final DateTimeValueType rhs = ((DateTimeValueType) o);
        if (!EqualsHelper.equals(value, rhs.value)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(value).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("value", value).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DateTimeValueType ret) {
        super.cloneTo(ret);
        ret.value = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DateTimeValueType clone() {
        DateTimeValueType ret = new DateTimeValueType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of value. May be <code>null</code>.
     */
    @Nullable
    public LocalDateTime getValueLocal() {
        return (value == null)?null:value.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be <code>null</code>.
     */
    public void setValue(
        @Nullable
        final LocalDateTime aValue) {
        value = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
