
package com.helger.regrep.rim;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import jakarta.activation.DataHandler;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *         Metadata data type capable of having repository content associated with it as a repository item.
 *         Often used as base type for extended types defines by profiles of ebXML RegRep.
 *       
 * 
 * <p>Java class for ExtrinsicObjectType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ExtrinsicObjectType">
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}RegistryObjectType">
 *       <sequence>
 *         <element name="ContentVersionInfo" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}VersionInfoType" minOccurs="0"/>
 *         <choice minOccurs="0">
 *           <element name="RepositoryItemRef" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}SimpleLinkType"/>
 *           <element name="RepositoryItem" type="{http://www.w3.org/2001/XMLSchema}base64Binary"/>
 *         </choice>
 *       </sequence>
 *       <attribute name="mimeType" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}LongText" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExtrinsicObjectType", propOrder = {
    "contentVersionInfo",
    "repositoryItemRef",
    "repositoryItem"
})
@XmlSeeAlso({
    CommentType.class
})
@CodingStyleguideUnaware
public class ExtrinsicObjectType
    extends RegistryObjectType
{

    @XmlElement(name = "ContentVersionInfo")
    private VersionInfoType contentVersionInfo;
    @XmlElement(name = "RepositoryItemRef")
    private SimpleLinkType repositoryItemRef;
    @XmlElement(name = "RepositoryItem")
    @XmlMimeType("*/*")
    private DataHandler repositoryItem;
    @XmlAttribute(name = "mimeType")
    private String mimeType;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ExtrinsicObjectType() {
    }

    /**
     * Gets the value of the contentVersionInfo property.
     * 
     * @return
     *     possible object is
     *     {@link VersionInfoType }
     *     
     */
    @Nullable
    public VersionInfoType getContentVersionInfo() {
        return contentVersionInfo;
    }

    /**
     * Sets the value of the contentVersionInfo property.
     * 
     * @param value
     *     allowed object is
     *     {@link VersionInfoType }
     *     
     */
    public void setContentVersionInfo(
        @Nullable
        VersionInfoType value) {
        this.contentVersionInfo = value;
    }

    /**
     * Gets the value of the repositoryItemRef property.
     * 
     * @return
     *     possible object is
     *     {@link SimpleLinkType }
     *     
     */
    @Nullable
    public SimpleLinkType getRepositoryItemRef() {
        return repositoryItemRef;
    }

    /**
     * Sets the value of the repositoryItemRef property.
     * 
     * @param value
     *     allowed object is
     *     {@link SimpleLinkType }
     *     
     */
    public void setRepositoryItemRef(
        @Nullable
        SimpleLinkType value) {
        this.repositoryItemRef = value;
    }

    /**
     * Gets the value of the repositoryItem property.
     * 
     * @return
     *     possible object is
     *     {@link DataHandler }
     *     
     */
    @Nullable
    public DataHandler getRepositoryItem() {
        return repositoryItem;
    }

    /**
     * Sets the value of the repositoryItem property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataHandler }
     *     
     */
    public void setRepositoryItem(
        @Nullable
        DataHandler value) {
        this.repositoryItem = value;
    }

    /**
     * Gets the value of the mimeType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getMimeType() {
        return mimeType;
    }

    /**
     * Sets the value of the mimeType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMimeType(
        @Nullable
        String value) {
        this.mimeType = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final ExtrinsicObjectType rhs = ((ExtrinsicObjectType) o);
        if (!EqualsHelper.equals(contentVersionInfo, rhs.contentVersionInfo)) {
            return false;
        }
        if (!EqualsHelper.equals(mimeType, rhs.mimeType)) {
            return false;
        }
        if (!EqualsHelper.equals(repositoryItem, rhs.repositoryItem)) {
            return false;
        }
        if (!EqualsHelper.equals(repositoryItemRef, rhs.repositoryItemRef)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(contentVersionInfo).append(mimeType).append(repositoryItem).append(repositoryItemRef).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("contentVersionInfo", contentVersionInfo).append("mimeType", mimeType).append("repositoryItem", repositoryItem).append("repositoryItemRef", repositoryItemRef).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ExtrinsicObjectType ret) {
        super.cloneTo(ret);
        ret.contentVersionInfo = ((contentVersionInfo == null)?null:contentVersionInfo.clone());
        ret.mimeType = mimeType;
        ret.repositoryItem = repositoryItem;
        ret.repositoryItemRef = ((repositoryItemRef == null)?null:repositoryItemRef.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ExtrinsicObjectType clone() {
        ExtrinsicObjectType ret = new ExtrinsicObjectType();
        cloneTo(ret);
        return ret;
    }

}
