
package com.helger.regrep.rim;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *         This type is the common base type for all query-able metadata elements in ebRIM.
 *       
 * 
 * <p>Java class for RegistryObjectType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="RegistryObjectType">
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}IdentifiableType">
 *       <sequence>
 *         <element name="Name" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}InternationalStringType" minOccurs="0"/>
 *         <element name="Description" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}InternationalStringType" minOccurs="0"/>
 *         <element name="VersionInfo" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}VersionInfoType" minOccurs="0"/>
 *         <element name="Classification" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ClassificationType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ExternalIdentifier" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExternalIdentifierType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ExternalLink" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExternalLinkType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="lid" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="objectType" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" />
 *       <attribute name="owner" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="status" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RegistryObjectType", propOrder = {
    "name",
    "description",
    "versionInfo",
    "classification",
    "externalIdentifier",
    "externalLink"
})
@XmlSeeAlso({
    NotificationType.class,
    AssociationType.class,
    AuditableEventType.class,
    ClassificationType.class,
    TaxonomyElementType.class,
    ExternalIdentifierType.class,
    ExternalLinkType.class,
    ExtrinsicObjectType.class,
    PartyType.class,
    RegistryPackageType.class,
    RoleType.class,
    ServiceType.class,
    ServiceEndpointType.class,
    ServiceBindingType.class,
    ServiceInterfaceType.class,
    RegistryType.class,
    FederationType.class,
    QueryDefinitionType.class,
    SubscriptionType.class,
    WorkflowActionType.class
})
@CodingStyleguideUnaware
public class RegistryObjectType
    extends IdentifiableType
{

    @XmlElement(name = "Name")
    private InternationalStringType name;
    @XmlElement(name = "Description")
    private InternationalStringType description;
    @XmlElement(name = "VersionInfo")
    private VersionInfoType versionInfo;
    @XmlElement(name = "Classification")
    private List<ClassificationType> classification;
    @XmlElement(name = "ExternalIdentifier")
    private List<ExternalIdentifierType> externalIdentifier;
    @XmlElement(name = "ExternalLink")
    private List<ExternalLinkType> externalLink;
    @XmlAttribute(name = "lid")
    private String lid;
    @XmlAttribute(name = "objectType")
    private String objectType;
    @XmlAttribute(name = "owner")
    private String owner;
    @XmlAttribute(name = "status")
    private String status;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public RegistryObjectType() {
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link InternationalStringType }
     *     
     */
    @Nullable
    public InternationalStringType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link InternationalStringType }
     *     
     */
    public void setName(
        @Nullable
        InternationalStringType value) {
        this.name = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link InternationalStringType }
     *     
     */
    @Nullable
    public InternationalStringType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link InternationalStringType }
     *     
     */
    public void setDescription(
        @Nullable
        InternationalStringType value) {
        this.description = value;
    }

    /**
     * Gets the value of the versionInfo property.
     * 
     * @return
     *     possible object is
     *     {@link VersionInfoType }
     *     
     */
    @Nullable
    public VersionInfoType getVersionInfo() {
        return versionInfo;
    }

    /**
     * Sets the value of the versionInfo property.
     * 
     * @param value
     *     allowed object is
     *     {@link VersionInfoType }
     *     
     */
    public void setVersionInfo(
        @Nullable
        VersionInfoType value) {
        this.versionInfo = value;
    }

    /**
     * Gets the value of the classification property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the classification property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClassificationType }
     * 
     * 
     * @return
     *     The value of the classification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ClassificationType> getClassification() {
        if (classification == null) {
            classification = new ArrayList<>();
        }
        return this.classification;
    }

    /**
     * Gets the value of the externalIdentifier property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the externalIdentifier property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExternalIdentifier().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExternalIdentifierType }
     * 
     * 
     * @return
     *     The value of the externalIdentifier property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ExternalIdentifierType> getExternalIdentifier() {
        if (externalIdentifier == null) {
            externalIdentifier = new ArrayList<>();
        }
        return this.externalIdentifier;
    }

    /**
     * Gets the value of the externalLink property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the externalLink property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExternalLink().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExternalLinkType }
     * 
     * 
     * @return
     *     The value of the externalLink property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ExternalLinkType> getExternalLink() {
        if (externalLink == null) {
            externalLink = new ArrayList<>();
        }
        return this.externalLink;
    }

    /**
     * Gets the value of the lid property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLid() {
        return lid;
    }

    /**
     * Sets the value of the lid property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLid(
        @Nullable
        String value) {
        this.lid = value;
    }

    /**
     * Gets the value of the objectType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getObjectType() {
        return objectType;
    }

    /**
     * Sets the value of the objectType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setObjectType(
        @Nullable
        String value) {
        this.objectType = value;
    }

    /**
     * Gets the value of the owner property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getOwner() {
        return owner;
    }

    /**
     * Sets the value of the owner property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOwner(
        @Nullable
        String value) {
        this.owner = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatus(
        @Nullable
        String value) {
        this.status = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final RegistryObjectType rhs = ((RegistryObjectType) o);
        if (!EqualsHelper.equalsCollection(classification, rhs.classification)) {
            return false;
        }
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(externalIdentifier, rhs.externalIdentifier)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(externalLink, rhs.externalLink)) {
            return false;
        }
        if (!EqualsHelper.equals(lid, rhs.lid)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(objectType, rhs.objectType)) {
            return false;
        }
        if (!EqualsHelper.equals(owner, rhs.owner)) {
            return false;
        }
        if (!EqualsHelper.equals(status, rhs.status)) {
            return false;
        }
        if (!EqualsHelper.equals(versionInfo, rhs.versionInfo)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(classification).append(description).append(externalIdentifier).append(externalLink).append(lid).append(name).append(objectType).append(owner).append(status).append(versionInfo).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("classification", classification).append("description", description).append("externalIdentifier", externalIdentifier).append("externalLink", externalLink).append("lid", lid).append("name", name).append("objectType", objectType).append("owner", owner).append("status", status).append("versionInfo", versionInfo).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setClassification(
        @Nullable
        final List<ClassificationType> aList) {
        classification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExternalIdentifier(
        @Nullable
        final List<ExternalIdentifierType> aList) {
        externalIdentifier = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExternalLink(
        @Nullable
        final List<ExternalLinkType> aList) {
        externalLink = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasClassificationEntries() {
        return (!getClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoClassificationEntries() {
        return getClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getClassificationCount() {
        return getClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ClassificationType getClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addClassification(
        @Nonnull
        final ClassificationType elem) {
        getClassification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExternalIdentifierEntries() {
        return (!getExternalIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExternalIdentifierEntries() {
        return getExternalIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExternalIdentifierCount() {
        return getExternalIdentifier().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ExternalIdentifierType getExternalIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExternalIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExternalIdentifier(
        @Nonnull
        final ExternalIdentifierType elem) {
        getExternalIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExternalLinkEntries() {
        return (!getExternalLink().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExternalLinkEntries() {
        return getExternalLink().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExternalLinkCount() {
        return getExternalLink().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ExternalLinkType getExternalLinkAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExternalLink().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExternalLink(
        @Nonnull
        final ExternalLinkType elem) {
        getExternalLink().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        RegistryObjectType ret) {
        super.cloneTo(ret);
        if (classification == null) {
            ret.classification = null;
        } else {
            List<ClassificationType> retClassification = new ArrayList<>();
            for (ClassificationType aItem: getClassification()) {
                retClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.classification = retClassification;
        }
        ret.description = ((description == null)?null:description.clone());
        if (externalIdentifier == null) {
            ret.externalIdentifier = null;
        } else {
            List<ExternalIdentifierType> retExternalIdentifier = new ArrayList<>();
            for (ExternalIdentifierType aItem: getExternalIdentifier()) {
                retExternalIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.externalIdentifier = retExternalIdentifier;
        }
        if (externalLink == null) {
            ret.externalLink = null;
        } else {
            List<ExternalLinkType> retExternalLink = new ArrayList<>();
            for (ExternalLinkType aItem: getExternalLink()) {
                retExternalLink.add(((aItem == null)?null:aItem.clone()));
            }
            ret.externalLink = retExternalLink;
        }
        ret.lid = lid;
        ret.name = ((name == null)?null:name.clone());
        ret.objectType = objectType;
        ret.owner = owner;
        ret.status = status;
        ret.versionInfo = ((versionInfo == null)?null:versionInfo.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RegistryObjectType clone() {
        RegistryObjectType ret = new RegistryObjectType();
        cloneTo(ret);
        return ret;
    }

}
