
package com.helger.regrep.rim;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.xlink.XLinkActuateType;
import com.helger.xsds.xlink.XLinkShowType;
import com.helger.xsds.xlink.XLinkTypeType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *       Incorporates the attributes defined for use in simple XLink 
 *       elements. The xlink:role attribute should be included to 
 *       indicate the WSDL version of the target document (e.g. 
 *       xlink:role="http://www.w3.org/2005/08/wsdl").
 *       
 * 
 * <p>Java class for SimpleLinkType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SimpleLinkType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attGroup ref="{http://www.w3.org/1999/xlink}simpleAttrs"/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SimpleLinkType")
@CodingStyleguideUnaware
public class SimpleLinkType implements Serializable, IExplicitlyCloneable
{

    @XmlAttribute(name = "type", namespace = "http://www.w3.org/1999/xlink")
    private XLinkTypeType type;
    @XmlAttribute(name = "href", namespace = "http://www.w3.org/1999/xlink")
    private String href;
    @XmlAttribute(name = "role", namespace = "http://www.w3.org/1999/xlink")
    private String role;
    @XmlAttribute(name = "arcrole", namespace = "http://www.w3.org/1999/xlink")
    private String arcrole;
    @XmlAttribute(name = "title", namespace = "http://www.w3.org/1999/xlink")
    private String title;
    @XmlAttribute(name = "show", namespace = "http://www.w3.org/1999/xlink")
    private XLinkShowType show;
    @XmlAttribute(name = "actuate", namespace = "http://www.w3.org/1999/xlink")
    private XLinkActuateType actuate;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SimpleLinkType() {
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link XLinkTypeType }
     *     
     */
    @Nullable
    public XLinkTypeType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link XLinkTypeType }
     *     
     */
    public void setType(
        @Nullable
        XLinkTypeType value) {
        this.type = value;
    }

    /**
     * Gets the value of the href property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getHref() {
        return href;
    }

    /**
     * Sets the value of the href property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHref(
        @Nullable
        String value) {
        this.href = value;
    }

    /**
     * Gets the value of the role property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getRole() {
        return role;
    }

    /**
     * Sets the value of the role property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRole(
        @Nullable
        String value) {
        this.role = value;
    }

    /**
     * Gets the value of the arcrole property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getArcrole() {
        return arcrole;
    }

    /**
     * Sets the value of the arcrole property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setArcrole(
        @Nullable
        String value) {
        this.arcrole = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(
        @Nullable
        String value) {
        this.title = value;
    }

    /**
     * Gets the value of the show property.
     * 
     * @return
     *     possible object is
     *     {@link XLinkShowType }
     *     
     */
    @Nullable
    public XLinkShowType getShow() {
        return show;
    }

    /**
     * Sets the value of the show property.
     * 
     * @param value
     *     allowed object is
     *     {@link XLinkShowType }
     *     
     */
    public void setShow(
        @Nullable
        XLinkShowType value) {
        this.show = value;
    }

    /**
     * Gets the value of the actuate property.
     * 
     * @return
     *     possible object is
     *     {@link XLinkActuateType }
     *     
     */
    @Nullable
    public XLinkActuateType getActuate() {
        return actuate;
    }

    /**
     * Sets the value of the actuate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XLinkActuateType }
     *     
     */
    public void setActuate(
        @Nullable
        XLinkActuateType value) {
        this.actuate = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SimpleLinkType rhs = ((SimpleLinkType) o);
        if (!EqualsHelper.equals(actuate, rhs.actuate)) {
            return false;
        }
        if (!EqualsHelper.equals(arcrole, rhs.arcrole)) {
            return false;
        }
        if (!EqualsHelper.equals(href, rhs.href)) {
            return false;
        }
        if (!EqualsHelper.equals(role, rhs.role)) {
            return false;
        }
        if (!EqualsHelper.equals(show, rhs.show)) {
            return false;
        }
        if (!EqualsHelper.equals(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actuate).append(arcrole).append(href).append(role).append(show).append(title).append(type).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actuate", actuate).append("arcrole", arcrole).append("href", href).append("role", role).append("show", show).append("title", title).append("type", type).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SimpleLinkType ret) {
        ret.actuate = actuate;
        ret.arcrole = arcrole;
        ret.href = href;
        ret.role = role;
        ret.show = show;
        ret.title = title;
        ret.type = type;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SimpleLinkType clone() {
        SimpleLinkType ret = new SimpleLinkType();
        cloneTo(ret);
        return ret;
    }

}
