
package com.helger.regrep.rim;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.Duration;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * Represents a Subscription for specified server Events.
 * 
 * <p>Java class for SubscriptionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SubscriptionType">
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}RegistryObjectType">
 *       <sequence>
 *         <element name="DeliveryInfo" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}DeliveryInfoType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Selector" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}QueryType"/>
 *       </sequence>
 *       <attribute name="startTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *       <attribute name="endTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *       <attribute name="notificationInterval" type="{http://www.w3.org/2001/XMLSchema}duration" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-offset-dt-extension</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SubscriptionType", propOrder = {
    "deliveryInfo",
    "selector"
})
@CodingStyleguideUnaware
public class SubscriptionType
    extends RegistryObjectType
{

    @XmlElement(name = "DeliveryInfo")
    private List<DeliveryInfoType> deliveryInfo;
    @XmlElement(name = "Selector", required = true)
    private QueryType selector;
    @XmlAttribute(name = "startTime")
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime startTime;
    @XmlAttribute(name = "endTime")
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime endTime;
    @XmlAttribute(name = "notificationInterval")
    private Duration notificationInterval;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SubscriptionType() {
    }

    /**
     * Gets the value of the deliveryInfo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the deliveryInfo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDeliveryInfo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DeliveryInfoType }
     * 
     * 
     * @return
     *     The value of the deliveryInfo property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DeliveryInfoType> getDeliveryInfo() {
        if (deliveryInfo == null) {
            deliveryInfo = new ArrayList<>();
        }
        return this.deliveryInfo;
    }

    /**
     * Gets the value of the selector property.
     * 
     * @return
     *     possible object is
     *     {@link QueryType }
     *     
     */
    @Nullable
    public QueryType getSelector() {
        return selector;
    }

    /**
     * Sets the value of the selector property.
     * 
     * @param value
     *     allowed object is
     *     {@link QueryType }
     *     
     */
    public void setSelector(
        @Nullable
        QueryType value) {
        this.selector = value;
    }

    /**
     * Gets the value of the startTime property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getStartTime() {
        return startTime;
    }

    /**
     * Sets the value of the startTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStartTime(
        @Nullable
        XMLOffsetDateTime value) {
        this.startTime = value;
    }

    /**
     * Gets the value of the endTime property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getEndTime() {
        return endTime;
    }

    /**
     * Sets the value of the endTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEndTime(
        @Nullable
        XMLOffsetDateTime value) {
        this.endTime = value;
    }

    /**
     * Gets the value of the notificationInterval property.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    @Nullable
    public Duration getNotificationInterval() {
        return notificationInterval;
    }

    /**
     * Sets the value of the notificationInterval property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setNotificationInterval(
        @Nullable
        Duration value) {
        this.notificationInterval = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final SubscriptionType rhs = ((SubscriptionType) o);
        if (!EqualsHelper.equalsCollection(deliveryInfo, rhs.deliveryInfo)) {
            return false;
        }
        if (!EqualsHelper.equals(endTime, rhs.endTime)) {
            return false;
        }
        if (!EqualsHelper.equals(notificationInterval, rhs.notificationInterval)) {
            return false;
        }
        if (!EqualsHelper.equals(selector, rhs.selector)) {
            return false;
        }
        if (!EqualsHelper.equals(startTime, rhs.startTime)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(deliveryInfo).append(endTime).append(notificationInterval).append(selector).append(startTime).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("deliveryInfo", deliveryInfo).append("endTime", endTime).append("notificationInterval", notificationInterval).append("selector", selector).append("startTime", startTime).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDeliveryInfo(
        @Nullable
        final List<DeliveryInfoType> aList) {
        deliveryInfo = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDeliveryInfoEntries() {
        return (!getDeliveryInfo().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDeliveryInfoEntries() {
        return getDeliveryInfo().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDeliveryInfoCount() {
        return getDeliveryInfo().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DeliveryInfoType getDeliveryInfoAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDeliveryInfo().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDeliveryInfo(
        @Nonnull
        final DeliveryInfoType elem) {
        getDeliveryInfo().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SubscriptionType ret) {
        super.cloneTo(ret);
        if (deliveryInfo == null) {
            ret.deliveryInfo = null;
        } else {
            List<DeliveryInfoType> retDeliveryInfo = new ArrayList<>();
            for (DeliveryInfoType aItem: getDeliveryInfo()) {
                retDeliveryInfo.add(((aItem == null)?null:aItem.clone()));
            }
            ret.deliveryInfo = retDeliveryInfo;
        }
        ret.endTime = endTime;
        ret.notificationInterval = notificationInterval;
        ret.selector = ((selector == null)?null:selector.clone());
        ret.startTime = startTime;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SubscriptionType clone() {
        SubscriptionType ret = new SubscriptionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of startTime. May be <code>null</code>.
     */
    @Nullable
    public LocalDateTime getStartTimeLocal() {
        return (startTime == null)?null:startTime.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be <code>null</code>.
     */
    public void setStartTime(
        @Nullable
        final LocalDateTime aValue) {
        startTime = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of endTime. May be <code>null</code>.
     */
    @Nullable
    public LocalDateTime getEndTimeLocal() {
        return (endTime == null)?null:endTime.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be <code>null</code>.
     */
    public void setEndTime(
        @Nullable
        final LocalDateTime aValue) {
        endTime = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
