
package com.helger.regrep.rs;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.query.QueryResponse;
import com.helger.regrep.rim.ExtensibleObjectType;
import com.helger.regrep.rim.ObjectRefListType;
import com.helger.regrep.rim.RegistryObjectListType;
import com.helger.regrep.spi.CatalogObjectsResponse;
import com.helger.regrep.spi.FilterObjectsResponse;
import com.helger.regrep.spi.ValidateObjectsResponse;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * Base type for all ebXML Registry responses
 * 
 * <p>Java class for RegistryResponseType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="RegistryResponseType">
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExtensibleObjectType">
 *       <sequence>
 *         <element name="Exception" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rs:4.0}RegistryExceptionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}RegistryObjectList" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ObjectRefList" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="status" use="required" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" />
 *       <attribute name="requestId" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RegistryResponseType", propOrder = {
    "exception",
    "registryObjectList",
    "objectRefList"
})
@XmlSeeAlso({
    FilterObjectsResponse.class,
    CatalogObjectsResponse.class,
    ValidateObjectsResponse.class,
    QueryResponse.class
})
@CodingStyleguideUnaware
public class RegistryResponseType
    extends ExtensibleObjectType
{

    @XmlElement(name = "Exception")
    private List<RegistryExceptionType> exception;
    @XmlElement(name = "RegistryObjectList", namespace = "urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0")
    private RegistryObjectListType registryObjectList;
    @XmlElement(name = "ObjectRefList", namespace = "urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0")
    private ObjectRefListType objectRefList;
    @XmlAttribute(name = "status", required = true)
    private String status;
    @XmlAttribute(name = "requestId")
    @XmlSchemaType(name = "anyURI")
    private String requestId;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public RegistryResponseType() {
    }

    /**
     * Gets the value of the exception property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the exception property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getException().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RegistryExceptionType }
     * 
     * 
     * @return
     *     The value of the exception property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RegistryExceptionType> getException() {
        if (exception == null) {
            exception = new ArrayList<>();
        }
        return this.exception;
    }

    /**
     * Gets the value of the registryObjectList property.
     * 
     * @return
     *     possible object is
     *     {@link RegistryObjectListType }
     *     
     */
    @Nullable
    public RegistryObjectListType getRegistryObjectList() {
        return registryObjectList;
    }

    /**
     * Sets the value of the registryObjectList property.
     * 
     * @param value
     *     allowed object is
     *     {@link RegistryObjectListType }
     *     
     */
    public void setRegistryObjectList(
        @Nullable
        RegistryObjectListType value) {
        this.registryObjectList = value;
    }

    /**
     * Gets the value of the objectRefList property.
     * 
     * @return
     *     possible object is
     *     {@link ObjectRefListType }
     *     
     */
    @Nullable
    public ObjectRefListType getObjectRefList() {
        return objectRefList;
    }

    /**
     * Sets the value of the objectRefList property.
     * 
     * @param value
     *     allowed object is
     *     {@link ObjectRefListType }
     *     
     */
    public void setObjectRefList(
        @Nullable
        ObjectRefListType value) {
        this.objectRefList = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatus(
        @Nullable
        String value) {
        this.status = value;
    }

    /**
     * Gets the value of the requestId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getRequestId() {
        return requestId;
    }

    /**
     * Sets the value of the requestId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRequestId(
        @Nullable
        String value) {
        this.requestId = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final RegistryResponseType rhs = ((RegistryResponseType) o);
        if (!EqualsHelper.equalsCollection(exception, rhs.exception)) {
            return false;
        }
        if (!EqualsHelper.equals(objectRefList, rhs.objectRefList)) {
            return false;
        }
        if (!EqualsHelper.equals(registryObjectList, rhs.registryObjectList)) {
            return false;
        }
        if (!EqualsHelper.equals(requestId, rhs.requestId)) {
            return false;
        }
        if (!EqualsHelper.equals(status, rhs.status)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(exception).append(objectRefList).append(registryObjectList).append(requestId).append(status).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("exception", exception).append("objectRefList", objectRefList).append("registryObjectList", registryObjectList).append("requestId", requestId).append("status", status).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setException(
        @Nullable
        final List<RegistryExceptionType> aList) {
        exception = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExceptionEntries() {
        return (!getException().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExceptionEntries() {
        return getException().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExceptionCount() {
        return getException().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RegistryExceptionType getExceptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getException().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addException(
        @Nonnull
        final RegistryExceptionType elem) {
        getException().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        RegistryResponseType ret) {
        super.cloneTo(ret);
        if (exception == null) {
            ret.exception = null;
        } else {
            List<RegistryExceptionType> retException = new ArrayList<>();
            for (RegistryExceptionType aItem: getException()) {
                retException.add(((aItem == null)?null:aItem.clone()));
            }
            ret.exception = retException;
        }
        ret.objectRefList = ((objectRefList == null)?null:objectRefList.clone());
        ret.registryObjectList = ((registryObjectList == null)?null:registryObjectList.clone());
        ret.requestId = requestId;
        ret.status = status;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RegistryResponseType clone() {
        RegistryResponseType ret = new RegistryResponseType();
        cloneTo(ret);
        return ret;
    }

}
