
package com.helger.regrep.spi;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.ExtrinsicObjectType;
import com.helger.regrep.rim.RegistryObjectListType;
import com.helger.regrep.rs.RegistryRequestType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType>
 *   <complexContent>
 *     <extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rs:4.0}RegistryRequestType">
 *       <sequence>
 *         <element name="OriginalObjects" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}RegistryObjectListType"/>
 *         <element name="InvocationControlFile" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExtrinsicObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "originalObjects",
    "invocationControlFile"
})
@XmlRootElement(name = "FilterObjectsRequest")
@CodingStyleguideUnaware
public class FilterObjectsRequest
    extends RegistryRequestType
{

    @XmlElement(name = "OriginalObjects", required = true)
    private RegistryObjectListType originalObjects;
    @XmlElement(name = "InvocationControlFile")
    private List<ExtrinsicObjectType> invocationControlFile;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public FilterObjectsRequest() {
    }

    /**
     * Gets the value of the originalObjects property.
     * 
     * @return
     *     possible object is
     *     {@link RegistryObjectListType }
     *     
     */
    @Nullable
    public RegistryObjectListType getOriginalObjects() {
        return originalObjects;
    }

    /**
     * Sets the value of the originalObjects property.
     * 
     * @param value
     *     allowed object is
     *     {@link RegistryObjectListType }
     *     
     */
    public void setOriginalObjects(
        @Nullable
        RegistryObjectListType value) {
        this.originalObjects = value;
    }

    /**
     * Gets the value of the invocationControlFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the invocationControlFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInvocationControlFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExtrinsicObjectType }
     * 
     * 
     * @return
     *     The value of the invocationControlFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ExtrinsicObjectType> getInvocationControlFile() {
        if (invocationControlFile == null) {
            invocationControlFile = new ArrayList<>();
        }
        return this.invocationControlFile;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final FilterObjectsRequest rhs = ((FilterObjectsRequest) o);
        if (!EqualsHelper.equalsCollection(invocationControlFile, rhs.invocationControlFile)) {
            return false;
        }
        if (!EqualsHelper.equals(originalObjects, rhs.originalObjects)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(invocationControlFile).append(originalObjects).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("invocationControlFile", invocationControlFile).append("originalObjects", originalObjects).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInvocationControlFile(
        @Nullable
        final List<ExtrinsicObjectType> aList) {
        invocationControlFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInvocationControlFileEntries() {
        return (!getInvocationControlFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInvocationControlFileEntries() {
        return getInvocationControlFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInvocationControlFileCount() {
        return getInvocationControlFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ExtrinsicObjectType getInvocationControlFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInvocationControlFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInvocationControlFile(
        @Nonnull
        final ExtrinsicObjectType elem) {
        getInvocationControlFile().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FilterObjectsRequest ret) {
        super.cloneTo(ret);
        if (invocationControlFile == null) {
            ret.invocationControlFile = null;
        } else {
            List<ExtrinsicObjectType> retInvocationControlFile = new ArrayList<>();
            for (ExtrinsicObjectType aItem: getInvocationControlFile()) {
                retInvocationControlFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.invocationControlFile = retInvocationControlFile;
        }
        ret.originalObjects = ((originalObjects == null)?null:originalObjects.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FilterObjectsRequest clone() {
        FilterObjectsRequest ret = new FilterObjectsRequest();
        cloneTo(ret);
        return ret;
    }

}
