/*
 * Decompiled with CFR 0.152.
 */
package com.helger.regrep.rim;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.EntryType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MapType", propOrder={"entry"})
@CodingStyleguideUnaware
public class MapType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="Entry")
    private List<EntryType> entry;

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<EntryType> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<EntryType>();
        }
        return this.entry;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapType mapType = (MapType)object;
        return EqualsHelper.equalsCollection(this.entry, mapType.entry);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.entry).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("entry", this.entry).getToString();
    }

    public void setEntry(@Nullable List<EntryType> list) {
        this.entry = list;
    }

    public boolean hasEntryEntries() {
        return !this.getEntry().isEmpty();
    }

    public boolean hasNoEntryEntries() {
        return this.getEntry().isEmpty();
    }

    @Nonnegative
    public int getEntryCount() {
        return this.getEntry().size();
    }

    @Nullable
    public EntryType getEntryAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getEntry().get(n);
    }

    public void addEntry(@Nonnull EntryType entryType) {
        this.getEntry().add(entryType);
    }

    public void cloneTo(@Nonnull MapType mapType) {
        if (this.entry == null) {
            mapType.entry = null;
        } else {
            ArrayList<EntryType> arrayList = new ArrayList<EntryType>();
            for (EntryType entryType : this.getEntry()) {
                arrayList.add(entryType == null ? null : entryType.clone());
            }
            mapType.entry = arrayList;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public MapType clone() {
        MapType mapType = new MapType();
        this.cloneTo(mapType);
        return mapType;
    }
}

