/*
 * Decompiled with CFR 0.152.
 */
package com.helger.regrep.rim;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.ExtensibleObjectType;
import com.helger.regrep.rim.InternationalStringType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ParameterType", propOrder={"name", "description"})
@CodingStyleguideUnaware
public class ParameterType
extends ExtensibleObjectType {
    @XmlElement(name="Name", required=true)
    private InternationalStringType name;
    @XmlElement(name="Description")
    private InternationalStringType description;
    @XmlAttribute(name="parameterName", required=true)
    private String parameterName;
    @XmlAttribute(name="dataType", required=true)
    private String dataType;
    @XmlAttribute(name="defaultValue")
    private String defaultValue;
    @XmlAttribute(name="minOccurs")
    @XmlSchemaType(name="nonNegativeInteger")
    private BigInteger minOccurs;
    @XmlAttribute(name="maxOccurs")
    @XmlSchemaType(name="nonNegativeInteger")
    private BigInteger maxOccurs;

    @Nullable
    public InternationalStringType getName() {
        return this.name;
    }

    public void setName(@Nullable InternationalStringType internationalStringType) {
        this.name = internationalStringType;
    }

    @Nullable
    public InternationalStringType getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable InternationalStringType internationalStringType) {
        this.description = internationalStringType;
    }

    @Nullable
    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(@Nullable String string) {
        this.parameterName = string;
    }

    @Nullable
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(@Nullable String string) {
        this.dataType = string;
    }

    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable String string) {
        this.defaultValue = string;
    }

    @Nullable
    public BigInteger getMinOccurs() {
        if (this.minOccurs == null) {
            return new BigInteger("1");
        }
        return this.minOccurs;
    }

    public void setMinOccurs(@Nullable BigInteger bigInteger) {
        this.minOccurs = bigInteger;
    }

    @Nullable
    public BigInteger getMaxOccurs() {
        if (this.maxOccurs == null) {
            return new BigInteger("1");
        }
        return this.maxOccurs;
    }

    public void setMaxOccurs(@Nullable BigInteger bigInteger) {
        this.maxOccurs = bigInteger;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ParameterType parameterType = (ParameterType)object;
        if (!EqualsHelper.equals((Object)this.dataType, (Object)parameterType.dataType)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.defaultValue, (Object)parameterType.defaultValue)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.description, (Object)parameterType.description)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.maxOccurs, (Object)parameterType.maxOccurs)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.minOccurs, (Object)parameterType.minOccurs)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.name, (Object)parameterType.name)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.parameterName, (Object)parameterType.parameterName);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.dataType).append((Object)this.defaultValue).append((Object)this.description).append((Object)this.maxOccurs).append((Object)this.minOccurs).append((Object)this.name).append((Object)this.parameterName).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("dataType", (Object)this.dataType).append("defaultValue", (Object)this.defaultValue).append("description", (Object)this.description).append("maxOccurs", (Object)this.maxOccurs).append("minOccurs", (Object)this.minOccurs).append("name", (Object)this.name).append("parameterName", (Object)this.parameterName).getToString();
    }

    public void cloneTo(@Nonnull ParameterType parameterType) {
        super.cloneTo(parameterType);
        parameterType.dataType = this.dataType;
        parameterType.defaultValue = this.defaultValue;
        parameterType.description = this.description == null ? null : this.description.clone();
        parameterType.maxOccurs = this.maxOccurs;
        parameterType.minOccurs = this.minOccurs;
        parameterType.name = this.name == null ? null : this.name.clone();
        parameterType.parameterName = this.parameterName;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ParameterType clone() {
        ParameterType parameterType = new ParameterType();
        this.cloneTo(parameterType);
        return parameterType;
    }
}

