/*
 * Decompiled with CFR 0.152.
 */
package com.helger.regrep.rim;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.EmailAddressType;
import com.helger.regrep.rim.OrganizationType;
import com.helger.regrep.rim.PersonType;
import com.helger.regrep.rim.PostalAddressType;
import com.helger.regrep.rim.RegistryObjectType;
import com.helger.regrep.rim.TelephoneNumberType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PartyType", propOrder={"postalAddress", "telephoneNumber", "emailAddress"})
@XmlSeeAlso(value={OrganizationType.class, PersonType.class})
@CodingStyleguideUnaware
public abstract class PartyType
extends RegistryObjectType {
    @XmlElement(name="PostalAddress")
    private List<PostalAddressType> postalAddress;
    @XmlElement(name="TelephoneNumber")
    private List<TelephoneNumberType> telephoneNumber;
    @XmlElement(name="EmailAddress")
    private List<EmailAddressType> emailAddress;

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PostalAddressType> getPostalAddress() {
        if (this.postalAddress == null) {
            this.postalAddress = new ArrayList<PostalAddressType>();
        }
        return this.postalAddress;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<TelephoneNumberType> getTelephoneNumber() {
        if (this.telephoneNumber == null) {
            this.telephoneNumber = new ArrayList<TelephoneNumberType>();
        }
        return this.telephoneNumber;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<EmailAddressType> getEmailAddress() {
        if (this.emailAddress == null) {
            this.emailAddress = new ArrayList<EmailAddressType>();
        }
        return this.emailAddress;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PartyType partyType = (PartyType)object;
        if (!EqualsHelper.equalsCollection(this.emailAddress, partyType.emailAddress)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.postalAddress, partyType.postalAddress)) {
            return false;
        }
        return EqualsHelper.equalsCollection(this.telephoneNumber, partyType.telephoneNumber);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.emailAddress).append(this.postalAddress).append(this.telephoneNumber).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("emailAddress", this.emailAddress).append("postalAddress", this.postalAddress).append("telephoneNumber", this.telephoneNumber).getToString();
    }

    public void setPostalAddress(@Nullable List<PostalAddressType> list) {
        this.postalAddress = list;
    }

    public void setTelephoneNumber(@Nullable List<TelephoneNumberType> list) {
        this.telephoneNumber = list;
    }

    public void setEmailAddress(@Nullable List<EmailAddressType> list) {
        this.emailAddress = list;
    }

    public boolean hasPostalAddressEntries() {
        return !this.getPostalAddress().isEmpty();
    }

    public boolean hasNoPostalAddressEntries() {
        return this.getPostalAddress().isEmpty();
    }

    @Nonnegative
    public int getPostalAddressCount() {
        return this.getPostalAddress().size();
    }

    @Nullable
    public PostalAddressType getPostalAddressAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getPostalAddress().get(n);
    }

    public void addPostalAddress(@Nonnull PostalAddressType postalAddressType) {
        this.getPostalAddress().add(postalAddressType);
    }

    public boolean hasTelephoneNumberEntries() {
        return !this.getTelephoneNumber().isEmpty();
    }

    public boolean hasNoTelephoneNumberEntries() {
        return this.getTelephoneNumber().isEmpty();
    }

    @Nonnegative
    public int getTelephoneNumberCount() {
        return this.getTelephoneNumber().size();
    }

    @Nullable
    public TelephoneNumberType getTelephoneNumberAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getTelephoneNumber().get(n);
    }

    public void addTelephoneNumber(@Nonnull TelephoneNumberType telephoneNumberType) {
        this.getTelephoneNumber().add(telephoneNumberType);
    }

    public boolean hasEmailAddressEntries() {
        return !this.getEmailAddress().isEmpty();
    }

    public boolean hasNoEmailAddressEntries() {
        return this.getEmailAddress().isEmpty();
    }

    @Nonnegative
    public int getEmailAddressCount() {
        return this.getEmailAddress().size();
    }

    @Nullable
    public EmailAddressType getEmailAddressAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getEmailAddress().get(n);
    }

    public void addEmailAddress(@Nonnull EmailAddressType emailAddressType) {
        this.getEmailAddress().add(emailAddressType);
    }

    public void cloneTo(@Nonnull PartyType partyType) {
        ArrayList<EmailAddressType> arrayList;
        super.cloneTo(partyType);
        if (this.emailAddress == null) {
            partyType.emailAddress = null;
        } else {
            arrayList = new ArrayList<EmailAddressType>();
            for (EmailAddressType extensibleObjectType : this.getEmailAddress()) {
                arrayList.add(extensibleObjectType == null ? null : extensibleObjectType.clone());
            }
            partyType.emailAddress = arrayList;
        }
        if (this.postalAddress == null) {
            partyType.postalAddress = null;
        } else {
            arrayList = new ArrayList();
            for (PostalAddressType postalAddressType : this.getPostalAddress()) {
                arrayList.add((EmailAddressType)((Object)(postalAddressType == null ? null : postalAddressType.clone())));
            }
            partyType.postalAddress = arrayList;
        }
        if (this.telephoneNumber == null) {
            partyType.telephoneNumber = null;
        } else {
            arrayList = new ArrayList();
            for (TelephoneNumberType telephoneNumberType : this.getTelephoneNumber()) {
                arrayList.add((EmailAddressType)((Object)(telephoneNumberType == null ? null : telephoneNumberType.clone())));
            }
            partyType.telephoneNumber = arrayList;
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public abstract PartyType clone();
}

