/*
 * Decompiled with CFR 0.152.
 */
package com.helger.regrep.rim;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.AssociationType;
import com.helger.regrep.rim.AuditableEventType;
import com.helger.regrep.rim.ClassificationType;
import com.helger.regrep.rim.ExternalIdentifierType;
import com.helger.regrep.rim.ExternalLinkType;
import com.helger.regrep.rim.ExtrinsicObjectType;
import com.helger.regrep.rim.FederationType;
import com.helger.regrep.rim.IdentifiableType;
import com.helger.regrep.rim.InternationalStringType;
import com.helger.regrep.rim.NotificationType;
import com.helger.regrep.rim.PartyType;
import com.helger.regrep.rim.QueryDefinitionType;
import com.helger.regrep.rim.RegistryPackageType;
import com.helger.regrep.rim.RegistryType;
import com.helger.regrep.rim.RoleType;
import com.helger.regrep.rim.ServiceBindingType;
import com.helger.regrep.rim.ServiceEndpointType;
import com.helger.regrep.rim.ServiceInterfaceType;
import com.helger.regrep.rim.ServiceType;
import com.helger.regrep.rim.SubscriptionType;
import com.helger.regrep.rim.TaxonomyElementType;
import com.helger.regrep.rim.VersionInfoType;
import com.helger.regrep.rim.WorkflowActionType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RegistryObjectType", propOrder={"name", "description", "versionInfo", "classification", "externalIdentifier", "externalLink"})
@XmlSeeAlso(value={NotificationType.class, AssociationType.class, AuditableEventType.class, ClassificationType.class, TaxonomyElementType.class, ExternalIdentifierType.class, ExternalLinkType.class, ExtrinsicObjectType.class, PartyType.class, RegistryPackageType.class, RoleType.class, ServiceType.class, ServiceEndpointType.class, ServiceBindingType.class, ServiceInterfaceType.class, RegistryType.class, FederationType.class, QueryDefinitionType.class, SubscriptionType.class, WorkflowActionType.class})
@CodingStyleguideUnaware
public class RegistryObjectType
extends IdentifiableType {
    @XmlElement(name="Name")
    private InternationalStringType name;
    @XmlElement(name="Description")
    private InternationalStringType description;
    @XmlElement(name="VersionInfo")
    private VersionInfoType versionInfo;
    @XmlElement(name="Classification")
    private List<ClassificationType> classification;
    @XmlElement(name="ExternalIdentifier")
    private List<ExternalIdentifierType> externalIdentifier;
    @XmlElement(name="ExternalLink")
    private List<ExternalLinkType> externalLink;
    @XmlAttribute(name="lid")
    private String lid;
    @XmlAttribute(name="objectType")
    private String objectType;
    @XmlAttribute(name="owner")
    private String owner;
    @XmlAttribute(name="status")
    private String status;

    @Nullable
    public InternationalStringType getName() {
        return this.name;
    }

    public void setName(@Nullable InternationalStringType internationalStringType) {
        this.name = internationalStringType;
    }

    @Nullable
    public InternationalStringType getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable InternationalStringType internationalStringType) {
        this.description = internationalStringType;
    }

    @Nullable
    public VersionInfoType getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(@Nullable VersionInfoType versionInfoType) {
        this.versionInfo = versionInfoType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ClassificationType> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<ClassificationType>();
        }
        return this.classification;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ExternalIdentifierType> getExternalIdentifier() {
        if (this.externalIdentifier == null) {
            this.externalIdentifier = new ArrayList<ExternalIdentifierType>();
        }
        return this.externalIdentifier;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ExternalLinkType> getExternalLink() {
        if (this.externalLink == null) {
            this.externalLink = new ArrayList<ExternalLinkType>();
        }
        return this.externalLink;
    }

    @Nullable
    public String getLid() {
        return this.lid;
    }

    public void setLid(@Nullable String string) {
        this.lid = string;
    }

    @Nullable
    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(@Nullable String string) {
        this.objectType = string;
    }

    @Nullable
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable String string) {
        this.owner = string;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable String string) {
        this.status = string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RegistryObjectType registryObjectType = (RegistryObjectType)object;
        if (!EqualsHelper.equalsCollection(this.classification, registryObjectType.classification)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.description, (Object)registryObjectType.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.externalIdentifier, registryObjectType.externalIdentifier)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.externalLink, registryObjectType.externalLink)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.lid, (Object)registryObjectType.lid)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.name, (Object)registryObjectType.name)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.objectType, (Object)registryObjectType.objectType)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.owner, (Object)registryObjectType.owner)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.status, (Object)registryObjectType.status)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.versionInfo, (Object)registryObjectType.versionInfo);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.classification).append((Object)this.description).append(this.externalIdentifier).append(this.externalLink).append((Object)this.lid).append((Object)this.name).append((Object)this.objectType).append((Object)this.owner).append((Object)this.status).append((Object)this.versionInfo).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("classification", this.classification).append("description", (Object)this.description).append("externalIdentifier", this.externalIdentifier).append("externalLink", this.externalLink).append("lid", (Object)this.lid).append("name", (Object)this.name).append("objectType", (Object)this.objectType).append("owner", (Object)this.owner).append("status", (Object)this.status).append("versionInfo", (Object)this.versionInfo).getToString();
    }

    public void setClassification(@Nullable List<ClassificationType> list) {
        this.classification = list;
    }

    public void setExternalIdentifier(@Nullable List<ExternalIdentifierType> list) {
        this.externalIdentifier = list;
    }

    public void setExternalLink(@Nullable List<ExternalLinkType> list) {
        this.externalLink = list;
    }

    public boolean hasClassificationEntries() {
        return !this.getClassification().isEmpty();
    }

    public boolean hasNoClassificationEntries() {
        return this.getClassification().isEmpty();
    }

    @Nonnegative
    public int getClassificationCount() {
        return this.getClassification().size();
    }

    @Nullable
    public ClassificationType getClassificationAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getClassification().get(n);
    }

    public void addClassification(@Nonnull ClassificationType classificationType) {
        this.getClassification().add(classificationType);
    }

    public boolean hasExternalIdentifierEntries() {
        return !this.getExternalIdentifier().isEmpty();
    }

    public boolean hasNoExternalIdentifierEntries() {
        return this.getExternalIdentifier().isEmpty();
    }

    @Nonnegative
    public int getExternalIdentifierCount() {
        return this.getExternalIdentifier().size();
    }

    @Nullable
    public ExternalIdentifierType getExternalIdentifierAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getExternalIdentifier().get(n);
    }

    public void addExternalIdentifier(@Nonnull ExternalIdentifierType externalIdentifierType) {
        this.getExternalIdentifier().add(externalIdentifierType);
    }

    public boolean hasExternalLinkEntries() {
        return !this.getExternalLink().isEmpty();
    }

    public boolean hasNoExternalLinkEntries() {
        return this.getExternalLink().isEmpty();
    }

    @Nonnegative
    public int getExternalLinkCount() {
        return this.getExternalLink().size();
    }

    @Nullable
    public ExternalLinkType getExternalLinkAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getExternalLink().get(n);
    }

    public void addExternalLink(@Nonnull ExternalLinkType externalLinkType) {
        this.getExternalLink().add(externalLinkType);
    }

    public void cloneTo(@Nonnull RegistryObjectType registryObjectType) {
        ArrayList<ClassificationType> arrayList;
        super.cloneTo(registryObjectType);
        if (this.classification == null) {
            registryObjectType.classification = null;
        } else {
            arrayList = new ArrayList<ClassificationType>();
            for (ClassificationType registryObjectType2 : this.getClassification()) {
                arrayList.add(registryObjectType2 == null ? null : registryObjectType2.clone());
            }
            registryObjectType.classification = arrayList;
        }
        InternationalStringType internationalStringType = registryObjectType.description = this.description == null ? null : this.description.clone();
        if (this.externalIdentifier == null) {
            registryObjectType.externalIdentifier = null;
        } else {
            arrayList = new ArrayList();
            for (ExternalIdentifierType externalIdentifierType : this.getExternalIdentifier()) {
                arrayList.add((ClassificationType)((Object)(externalIdentifierType == null ? null : externalIdentifierType.clone())));
            }
            registryObjectType.externalIdentifier = arrayList;
        }
        if (this.externalLink == null) {
            registryObjectType.externalLink = null;
        } else {
            arrayList = new ArrayList();
            for (ExternalLinkType externalLinkType : this.getExternalLink()) {
                arrayList.add((ClassificationType)((Object)(externalLinkType == null ? null : externalLinkType.clone())));
            }
            registryObjectType.externalLink = arrayList;
        }
        registryObjectType.lid = this.lid;
        registryObjectType.name = this.name == null ? null : this.name.clone();
        registryObjectType.objectType = this.objectType;
        registryObjectType.owner = this.owner;
        registryObjectType.status = this.status;
        registryObjectType.versionInfo = this.versionInfo == null ? null : this.versionInfo.clone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public RegistryObjectType clone() {
        RegistryObjectType registryObjectType = new RegistryObjectType();
        this.cloneTo(registryObjectType);
        return registryObjectType;
    }
}

