/*
 * Decompiled with CFR 0.152.
 */
package com.helger.regrep.slot;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.text.IMultilingualText;
import com.helger.regrep.helper.VocabularyTerm;
import com.helger.regrep.rim.AnyValueType;
import com.helger.regrep.rim.BooleanValueType;
import com.helger.regrep.rim.CollectionValueType;
import com.helger.regrep.rim.DateTimeValueType;
import com.helger.regrep.rim.EntryType;
import com.helger.regrep.rim.FloatValueType;
import com.helger.regrep.rim.IntegerValueType;
import com.helger.regrep.rim.InternationalStringType;
import com.helger.regrep.rim.InternationalStringValueType;
import com.helger.regrep.rim.LocalizedStringType;
import com.helger.regrep.rim.MapType;
import com.helger.regrep.rim.MapValueType;
import com.helger.regrep.rim.SlotType;
import com.helger.regrep.rim.SlotValueType;
import com.helger.regrep.rim.StringValueType;
import com.helger.regrep.rim.ValueType;
import com.helger.regrep.rim.VocabularyTermType;
import com.helger.regrep.rim.VocabularyTermValueType;
import com.helger.regrep.slot.ERegRepCollectionType;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Element;

@Immutable
public final class SlotHelper {
    private SlotHelper() {
    }

    @Nonnull
    public static LocalizedStringType createLocalizedString(@Nonnull Locale locale, @Nonnull String string) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        ValueEnforcer.notNull((Object)string, (String)"Text");
        return SlotHelper.createLocalizedString(locale.getLanguage(), string);
    }

    @Nonnull
    public static LocalizedStringType createLocalizedString(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Language");
        ValueEnforcer.notNull((Object)string2, (String)"Text");
        LocalizedStringType localizedStringType = new LocalizedStringType();
        localizedStringType.setLang(string);
        localizedStringType.setValue(string2);
        return localizedStringType;
    }

    @Nonnull
    public static InternationalStringType createInternationalStringType(@Nullable Map<String, String> map) {
        ValueEnforcer.noNullValue(map, (String)"Map");
        InternationalStringType internationalStringType = new InternationalStringType();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                internationalStringType.addLocalizedString(SlotHelper.createLocalizedString(entry.getKey(), entry.getValue()));
            }
        }
        return internationalStringType;
    }

    @Nonnull
    public static InternationalStringType createInternationalStringType(@Nullable IMultilingualText iMultilingualText) {
        InternationalStringType internationalStringType = new InternationalStringType();
        if (iMultilingualText != null) {
            for (Map.Entry entry : iMultilingualText.texts().entrySet()) {
                internationalStringType.addLocalizedString(SlotHelper.createLocalizedString((Locale)entry.getKey(), (String)entry.getValue()));
            }
        }
        return internationalStringType;
    }

    @Nonnull
    public static InternationalStringType createInternationalStringType(LocalizedStringType ... localizedStringTypeArray) {
        ValueEnforcer.noNullValue((Object[])localizedStringTypeArray, (String)"Array");
        InternationalStringType internationalStringType = new InternationalStringType();
        if (localizedStringTypeArray != null) {
            for (LocalizedStringType localizedStringType : localizedStringTypeArray) {
                internationalStringType.addLocalizedString(localizedStringType);
            }
        }
        return internationalStringType;
    }

    @Nonnull
    public static MapType createMap(@Nullable Map<? extends ValueType, ? extends ValueType> map) {
        ValueEnforcer.notNull(map, (String)"Value");
        MapType mapType = new MapType();
        if (map != null) {
            for (Map.Entry<? extends ValueType, ? extends ValueType> entry : map.entrySet()) {
                EntryType entryType = new EntryType();
                entryType.setEntryKey(entry.getKey());
                entryType.setEntryValue(entry.getValue());
                mapType.addEntry(entryType);
            }
        }
        return mapType;
    }

    @Nonnull
    public static VocabularyTermType createVocabularyTerm(@Nonnull VocabularyTerm vocabularyTerm) {
        ValueEnforcer.notNull((Object)vocabularyTerm, (String)"Term");
        return SlotHelper.createVocabularyTerm(vocabularyTerm.getVocabulary(), vocabularyTerm.getTerm());
    }

    @Nonnull
    public static VocabularyTermType createVocabularyTerm(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"Vocabulary");
        ValueEnforcer.notNull((Object)string2, (String)"Term");
        VocabularyTermType vocabularyTermType = new VocabularyTermType();
        vocabularyTermType.setVocabulary(string);
        vocabularyTermType.setTerm(string2);
        return vocabularyTermType;
    }

    @Nonnull
    public static AnyValueType createSlotValue(@Nonnull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"Value");
        AnyValueType anyValueType = new AnyValueType();
        anyValueType.setAny(element);
        return anyValueType;
    }

    @Nonnull
    public static BooleanValueType createSlotValue(boolean bl) {
        return new BooleanValueType(bl);
    }

    @Nonnull
    public static CollectionValueType createSlotValue(ValueType ... valueTypeArray) {
        return SlotHelper.createSlotValue((ERegRepCollectionType)null, valueTypeArray);
    }

    @Nonnull
    public static CollectionValueType createSlotValue(@Nullable ERegRepCollectionType eRegRepCollectionType, ValueType ... valueTypeArray) {
        ValueEnforcer.noNullValue((Object[])valueTypeArray, (String)"Value");
        CollectionValueType collectionValueType = new CollectionValueType();
        if (eRegRepCollectionType != null) {
            collectionValueType.setCollectionType(eRegRepCollectionType.getID());
        }
        if (valueTypeArray != null) {
            for (ValueType valueType : valueTypeArray) {
                collectionValueType.addElement(valueType);
            }
        }
        return collectionValueType;
    }

    @Nonnull
    public static CollectionValueType createSlotValue(@Nullable ERegRepCollectionType eRegRepCollectionType, @Nullable Iterable<? extends ValueType> iterable) {
        ValueEnforcer.noNullValue(iterable, (String)"Value");
        CollectionValueType collectionValueType = new CollectionValueType();
        if (eRegRepCollectionType != null) {
            collectionValueType.setCollectionType(eRegRepCollectionType.getID());
        }
        if (iterable != null) {
            for (ValueType valueType : iterable) {
                collectionValueType.addElement(valueType);
            }
        }
        return collectionValueType;
    }

    @Nonnull
    public static DateTimeValueType createSlotValue(@Nonnull OffsetDateTime offsetDateTime) {
        ValueEnforcer.notNull((Object)offsetDateTime, (String)"Value");
        return new DateTimeValueType(XMLOffsetDateTime.of((OffsetDateTime)offsetDateTime));
    }

    @Nonnull
    public static DateTimeValueType createSlotValue(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        ValueEnforcer.notNull((Object)xMLOffsetDateTime, (String)"Value");
        return new DateTimeValueType(xMLOffsetDateTime);
    }

    @Nonnull
    public static FloatValueType createSlotValue(float f) {
        return new FloatValueType(Float.valueOf(f));
    }

    @Nonnull
    public static IntegerValueType createSlotValue(@Nonnull BigInteger bigInteger) {
        ValueEnforcer.notNull((Object)bigInteger, (String)"Value");
        return new IntegerValueType(bigInteger);
    }

    @Nonnull
    public static InternationalStringValueType createSlotValue(@Nonnull InternationalStringType internationalStringType) {
        ValueEnforcer.notNull((Object)internationalStringType, (String)"Value");
        return new InternationalStringValueType(internationalStringType);
    }

    @Nonnull
    public static MapValueType createSlotValue(@Nonnull MapType mapType) {
        ValueEnforcer.notNull((Object)mapType, (String)"Value");
        MapValueType mapValueType = new MapValueType();
        mapValueType.setMap(mapType);
        return mapValueType;
    }

    @Nonnull
    public static SlotValueType createSlotValue(@Nonnull SlotType slotType) {
        ValueEnforcer.notNull((Object)slotType, (String)"Value");
        SlotValueType slotValueType = new SlotValueType();
        slotValueType.setSlot(slotType);
        return slotValueType;
    }

    @Nonnull
    public static StringValueType createSlotValue(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        return new StringValueType(string);
    }

    @Nonnull
    public static VocabularyTermValueType createSlotValue(@Nonnull VocabularyTermType vocabularyTermType) {
        ValueEnforcer.notNull((Object)vocabularyTermType, (String)"Value");
        return new VocabularyTermValueType(vocabularyTermType);
    }

    @Nonnull
    public static SlotType createSlot(@Nonnull @Nonempty String string, @Nonnull ValueType valueType) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)valueType, (String)"Value");
        SlotType slotType = new SlotType();
        slotType.setName(string);
        slotType.setSlotValue(valueType);
        return slotType;
    }
}

