/*
 * Decompiled with CFR 0.152.
 */
package com.helger.regrep.spi;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.regrep.rim.ExtrinsicObjectType;
import com.helger.regrep.rim.ObjectRefListType;
import com.helger.regrep.rim.QueryType;
import com.helger.regrep.rim.RegistryObjectListType;
import com.helger.regrep.rs.RegistryRequestType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"query", "objectRefList", "originalObjects", "invocationControlFile"})
@XmlRootElement(name="CatalogObjectsRequest")
@CodingStyleguideUnaware
public class CatalogObjectsRequest
extends RegistryRequestType {
    @XmlElement(name="Query")
    private QueryType query;
    @XmlElement(name="ObjectRefList", namespace="urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0")
    private ObjectRefListType objectRefList;
    @XmlElement(name="OriginalObjects")
    private RegistryObjectListType originalObjects;
    @XmlElement(name="InvocationControlFile")
    private List<ExtrinsicObjectType> invocationControlFile;

    @Nullable
    public QueryType getQuery() {
        return this.query;
    }

    public void setQuery(@Nullable QueryType queryType) {
        this.query = queryType;
    }

    @Nullable
    public ObjectRefListType getObjectRefList() {
        return this.objectRefList;
    }

    public void setObjectRefList(@Nullable ObjectRefListType objectRefListType) {
        this.objectRefList = objectRefListType;
    }

    @Nullable
    public RegistryObjectListType getOriginalObjects() {
        return this.originalObjects;
    }

    public void setOriginalObjects(@Nullable RegistryObjectListType registryObjectListType) {
        this.originalObjects = registryObjectListType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ExtrinsicObjectType> getInvocationControlFile() {
        if (this.invocationControlFile == null) {
            this.invocationControlFile = new ArrayList<ExtrinsicObjectType>();
        }
        return this.invocationControlFile;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CatalogObjectsRequest catalogObjectsRequest = (CatalogObjectsRequest)object;
        if (!EqualsHelper.equalsCollection(this.invocationControlFile, catalogObjectsRequest.invocationControlFile)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.objectRefList, (Object)catalogObjectsRequest.objectRefList)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.originalObjects, (Object)catalogObjectsRequest.originalObjects)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.query, (Object)catalogObjectsRequest.query);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.invocationControlFile).append((Object)this.objectRefList).append((Object)this.originalObjects).append((Object)this.query).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("invocationControlFile", this.invocationControlFile).append("objectRefList", (Object)this.objectRefList).append("originalObjects", (Object)this.originalObjects).append("query", (Object)this.query).getToString();
    }

    public void setInvocationControlFile(@Nullable List<ExtrinsicObjectType> list) {
        this.invocationControlFile = list;
    }

    public boolean hasInvocationControlFileEntries() {
        return !this.getInvocationControlFile().isEmpty();
    }

    public boolean hasNoInvocationControlFileEntries() {
        return this.getInvocationControlFile().isEmpty();
    }

    @Nonnegative
    public int getInvocationControlFileCount() {
        return this.getInvocationControlFile().size();
    }

    @Nullable
    public ExtrinsicObjectType getInvocationControlFileAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getInvocationControlFile().get(n);
    }

    public void addInvocationControlFile(@Nonnull ExtrinsicObjectType extrinsicObjectType) {
        this.getInvocationControlFile().add(extrinsicObjectType);
    }

    public void cloneTo(@Nonnull CatalogObjectsRequest catalogObjectsRequest) {
        super.cloneTo(catalogObjectsRequest);
        if (this.invocationControlFile == null) {
            catalogObjectsRequest.invocationControlFile = null;
        } else {
            ArrayList<ExtrinsicObjectType> arrayList = new ArrayList<ExtrinsicObjectType>();
            for (ExtrinsicObjectType extrinsicObjectType : this.getInvocationControlFile()) {
                arrayList.add(extrinsicObjectType == null ? null : extrinsicObjectType.clone());
            }
            catalogObjectsRequest.invocationControlFile = arrayList;
        }
        catalogObjectsRequest.objectRefList = this.objectRefList == null ? null : this.objectRefList.clone();
        catalogObjectsRequest.originalObjects = this.originalObjects == null ? null : this.originalObjects.clone();
        catalogObjectsRequest.query = this.query == null ? null : this.query.clone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CatalogObjectsRequest clone() {
        CatalogObjectsRequest catalogObjectsRequest = new CatalogObjectsRequest();
        this.cloneTo(catalogObjectsRequest);
        return catalogObjectsRequest;
    }
}

