
package org.unece.cefact.namespaces.sbdh;

import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for CorrelationInformation complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="CorrelationInformation">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="RequestingDocumentCreationDateTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         <element name="RequestingDocumentInstanceIdentifier" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="ExpectedResponseDateTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-offset-dt-extension</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CorrelationInformation", propOrder = {
    "requestingDocumentCreationDateTime",
    "requestingDocumentInstanceIdentifier",
    "expectedResponseDateTime"
})
@CodingStyleguideUnaware
public class CorrelationInformation implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "RequestingDocumentCreationDateTime", type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime requestingDocumentCreationDateTime;
    @XmlElement(name = "RequestingDocumentInstanceIdentifier")
    private String requestingDocumentInstanceIdentifier;
    @XmlElement(name = "ExpectedResponseDateTime", type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime expectedResponseDateTime;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public CorrelationInformation() {
    }

    /**
     * Gets the value of the requestingDocumentCreationDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getRequestingDocumentCreationDateTime() {
        return requestingDocumentCreationDateTime;
    }

    /**
     * Sets the value of the requestingDocumentCreationDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRequestingDocumentCreationDateTime(
        @Nullable
        XMLOffsetDateTime value) {
        this.requestingDocumentCreationDateTime = value;
    }

    /**
     * Gets the value of the requestingDocumentInstanceIdentifier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getRequestingDocumentInstanceIdentifier() {
        return requestingDocumentInstanceIdentifier;
    }

    /**
     * Sets the value of the requestingDocumentInstanceIdentifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRequestingDocumentInstanceIdentifier(
        @Nullable
        String value) {
        this.requestingDocumentInstanceIdentifier = value;
    }

    /**
     * Gets the value of the expectedResponseDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getExpectedResponseDateTime() {
        return expectedResponseDateTime;
    }

    /**
     * Sets the value of the expectedResponseDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setExpectedResponseDateTime(
        @Nullable
        XMLOffsetDateTime value) {
        this.expectedResponseDateTime = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CorrelationInformation rhs = ((CorrelationInformation) o);
        if (!EqualsHelper.equals(expectedResponseDateTime, rhs.expectedResponseDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(requestingDocumentCreationDateTime, rhs.requestingDocumentCreationDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(requestingDocumentInstanceIdentifier, rhs.requestingDocumentInstanceIdentifier)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(expectedResponseDateTime).append(requestingDocumentCreationDateTime).append(requestingDocumentInstanceIdentifier).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("expectedResponseDateTime", expectedResponseDateTime).append("requestingDocumentCreationDateTime", requestingDocumentCreationDateTime).append("requestingDocumentInstanceIdentifier", requestingDocumentInstanceIdentifier).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CorrelationInformation ret) {
        ret.expectedResponseDateTime = expectedResponseDateTime;
        ret.requestingDocumentCreationDateTime = requestingDocumentCreationDateTime;
        ret.requestingDocumentInstanceIdentifier = requestingDocumentInstanceIdentifier;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CorrelationInformation clone() {
        CorrelationInformation ret = new CorrelationInformation();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of requestingDocumentCreationDateTime. May be <code>null</code>.
     */
    @Nullable
    public LocalDateTime getRequestingDocumentCreationDateTimeLocal() {
        return (requestingDocumentCreationDateTime == null)?null:requestingDocumentCreationDateTime.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be <code>null</code>.
     */
    public void setRequestingDocumentCreationDateTime(
        @Nullable
        final LocalDateTime aValue) {
        requestingDocumentCreationDateTime = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of expectedResponseDateTime. May be <code>null</code>.
     */
    @Nullable
    public LocalDateTime getExpectedResponseDateTimeLocal() {
        return (expectedResponseDateTime == null)?null:expectedResponseDateTime.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be <code>null</code>.
     */
    public void setExpectedResponseDateTime(
        @Nullable
        final LocalDateTime aValue) {
        expectedResponseDateTime = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
