
package org.unece.cefact.namespaces.sbdh;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ManifestItem complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ManifestItem">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="MimeTypeQualifierCode" type="{http://www.unece.org/cefact/namespaces/StandardBusinessDocumentHeader}MimeTypeQualifier"/>
 *         <element name="UniformResourceIdentifier" type="{http://www.w3.org/2001/XMLSchema}anyURI"/>
 *         <element name="Description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="LanguageCode" type="{http://www.unece.org/cefact/namespaces/StandardBusinessDocumentHeader}Language" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ManifestItem", propOrder = {
    "mimeTypeQualifierCode",
    "uniformResourceIdentifier",
    "description",
    "languageCode"
})
@CodingStyleguideUnaware
public class ManifestItem implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "MimeTypeQualifierCode", required = true)
    private String mimeTypeQualifierCode;
    @XmlElement(name = "UniformResourceIdentifier", required = true)
    @XmlSchemaType(name = "anyURI")
    private String uniformResourceIdentifier;
    @XmlElement(name = "Description")
    private String description;
    @XmlElement(name = "LanguageCode")
    private String languageCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ManifestItem() {
    }

    /**
     * Gets the value of the mimeTypeQualifierCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getMimeTypeQualifierCode() {
        return mimeTypeQualifierCode;
    }

    /**
     * Sets the value of the mimeTypeQualifierCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMimeTypeQualifierCode(
        @Nullable
        String value) {
        this.mimeTypeQualifierCode = value;
    }

    /**
     * Gets the value of the uniformResourceIdentifier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getUniformResourceIdentifier() {
        return uniformResourceIdentifier;
    }

    /**
     * Sets the value of the uniformResourceIdentifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUniformResourceIdentifier(
        @Nullable
        String value) {
        this.uniformResourceIdentifier = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(
        @Nullable
        String value) {
        this.description = value;
    }

    /**
     * Gets the value of the languageCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLanguageCode() {
        return languageCode;
    }

    /**
     * Sets the value of the languageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLanguageCode(
        @Nullable
        String value) {
        this.languageCode = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ManifestItem rhs = ((ManifestItem) o);
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(languageCode, rhs.languageCode)) {
            return false;
        }
        if (!EqualsHelper.equals(mimeTypeQualifierCode, rhs.mimeTypeQualifierCode)) {
            return false;
        }
        if (!EqualsHelper.equals(uniformResourceIdentifier, rhs.uniformResourceIdentifier)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(description).append(languageCode).append(mimeTypeQualifierCode).append(uniformResourceIdentifier).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("description", description).append("languageCode", languageCode).append("mimeTypeQualifierCode", mimeTypeQualifierCode).append("uniformResourceIdentifier", uniformResourceIdentifier).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ManifestItem ret) {
        ret.description = description;
        ret.languageCode = languageCode;
        ret.mimeTypeQualifierCode = mimeTypeQualifierCode;
        ret.uniformResourceIdentifier = uniformResourceIdentifier;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ManifestItem clone() {
        ManifestItem ret = new ManifestItem();
        cloneTo(ret);
        return ret;
    }

}
