/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.ISchematronResource;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractSchematronResource
implements ISchematronResource {
    private final IReadableResource m_aResource;
    private final String m_sResourceID;

    public AbstractSchematronResource(@Nonnull IReadableResource iReadableResource) {
        this.m_aResource = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_sResourceID = iReadableResource.getResourceID();
    }

    @Nonnull
    public final String getID() {
        return this.m_sResourceID;
    }

    @Override
    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aResource;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("resource", (Object)this.m_aResource).toString();
    }
}

