/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.resource.inmemory.AbstractMemoryReadableResource;
import com.helger.commons.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.commons.io.resource.inmemory.ReadableResourceInputStream;
import com.helger.commons.state.EValidity;
import com.helger.commons.xml.serialize.read.DOMReader;
import com.helger.commons.xml.serialize.write.XMLWriterSettings;
import com.helger.schematron.AbstractSchematronResource;
import com.helger.schematron.SchematronException;
import com.helger.schematron.SchematronResourceHelper;
import com.helger.schematron.pure.bound.IPSBoundSchema;
import com.helger.schematron.pure.bound.PSBoundSchemaCache;
import com.helger.schematron.pure.bound.PSBoundSchemaCacheKey;
import com.helger.schematron.pure.errorhandler.DoNothingPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.exchange.PSWriter;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.svrl.SVRLWriter;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class SchematronResourcePure
extends AbstractSchematronResource {
    private String m_sPhase;
    private IPSErrorHandler m_aErrorHandler;
    private XPathVariableResolver m_aVariableResolver;
    private XPathFunctionResolver m_aFunctionResolver;
    private IPSBoundSchema m_aBoundSchema;

    public SchematronResourcePure(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, null, null);
    }

    public SchematronResourcePure(@Nonnull IReadableResource iReadableResource, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler) {
        super(iReadableResource);
        this.setPhase(string);
        this.setErrorHandler(iPSErrorHandler);
    }

    @Nullable
    public String getPhase() {
        return this.m_sPhase;
    }

    @Nonnull
    public SchematronResourcePure setPhase(@Nullable String string) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_sPhase = string;
        return this;
    }

    @Nullable
    public IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nonnull
    public SchematronResourcePure setErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_aErrorHandler = iPSErrorHandler;
        return this;
    }

    @Nullable
    public XPathVariableResolver getVariableResolver() {
        return this.m_aVariableResolver;
    }

    @Nonnull
    public SchematronResourcePure setVariableResolver(@Nullable XPathVariableResolver xPathVariableResolver) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_aVariableResolver = xPathVariableResolver;
        return this;
    }

    @Nullable
    public XPathFunctionResolver getFunctionResolver() {
        return this.m_aFunctionResolver;
    }

    @Nonnull
    public SchematronResourcePure setFunctionResolver(@Nullable XPathFunctionResolver xPathFunctionResolver) {
        if (this.m_aBoundSchema != null) {
            throw new IllegalStateException("Schematron was already bound and can therefore not be altered!");
        }
        this.m_aFunctionResolver = xPathFunctionResolver;
        return this;
    }

    @Nonnull
    protected IPSBoundSchema createBoundSchema() {
        IReadableResource iReadableResource = this.getResource();
        IPSErrorHandler iPSErrorHandler = this.getErrorHandler();
        PSBoundSchemaCacheKey pSBoundSchemaCacheKey = new PSBoundSchemaCacheKey(iReadableResource, this.getPhase(), iPSErrorHandler, this.getVariableResolver(), this.getFunctionResolver());
        if (iReadableResource instanceof AbstractMemoryReadableResource) {
            try {
                return pSBoundSchemaCacheKey.createBoundSchema();
            }
            catch (SchematronException schematronException) {
                throw new IllegalStateException("Failed to bind Schematron", schematronException);
            }
        }
        return (IPSBoundSchema)PSBoundSchemaCache.getInstance().getFromCache(pSBoundSchemaCacheKey);
    }

    @Nonnull
    protected IPSBoundSchema getOrCreateBoundSchema() {
        if (this.m_aBoundSchema == null) {
            try {
                this.m_aBoundSchema = this.createBoundSchema();
            }
            catch (RuntimeException runtimeException) {
                if (this.m_aErrorHandler != null) {
                    this.m_aErrorHandler.error(this.getResource(), null, "Error creating bound schema", runtimeException);
                }
                throw runtimeException;
            }
        }
        return this.m_aBoundSchema;
    }

    @Override
    public boolean isValidSchematron() {
        try {
            IPSErrorHandler iPSErrorHandler = this.m_aErrorHandler != null ? this.m_aErrorHandler : new DoNothingPSErrorHandler();
            return this.getOrCreateBoundSchema().getOriginalSchema().isValid(iPSErrorHandler);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public void validateCompletely() {
        IPSErrorHandler iPSErrorHandler = this.m_aErrorHandler != null ? this.m_aErrorHandler : new DoNothingPSErrorHandler();
        this.validateCompletely(iPSErrorHandler);
    }

    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        ValueEnforcer.notNull((Object)iPSErrorHandler, (String)"ErrorHandler");
        try {
            this.getOrCreateBoundSchema().getOriginalSchema().validateCompletely(iPSErrorHandler);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nonnull
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Node node) throws SchematronException {
        return this.getOrCreateBoundSchema().validateComplete(node);
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull IHasInputStream iHasInputStream) throws Exception {
        if (!this.isValidSchematron()) {
            return EValidity.INVALID;
        }
        Document document = DOMReader.readXMLDOM((InputStream)iHasInputStream.getInputStream());
        if (document == null) {
            throw new IllegalArgumentException("Failed to read resource " + iHasInputStream + " as XML");
        }
        return this.getOrCreateBoundSchema().validatePartially(document);
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull Source source) throws Exception {
        if (!this.isValidSchematron()) {
            return EValidity.INVALID;
        }
        Node node = SchematronResourceHelper.getNodeOfSource(source);
        if (node == null) {
            return EValidity.INVALID;
        }
        return this.getOrCreateBoundSchema().validatePartially(node);
    }

    @Override
    @Nullable
    public Document applySchematronValidation(@Nonnull IHasInputStream iHasInputStream) throws Exception {
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(iHasInputStream);
        return schematronOutputType == null ? null : SVRLWriter.createXML(schematronOutputType);
    }

    @Override
    @Nullable
    public Document applySchematronValidation(@Nonnull Source source) throws Exception {
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(source);
        return schematronOutputType == null ? null : SVRLWriter.createXML(schematronOutputType);
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull IHasInputStream iHasInputStream) throws Exception {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"XMLResource");
        if (!this.isValidSchematron()) {
            return null;
        }
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        Document document = DOMReader.readXMLDOM((InputStream)inputStream);
        if (document == null) {
            throw new IllegalArgumentException("Failed to read resource " + iHasInputStream + " as XML");
        }
        return this.applySchematronValidationToSVRL(document);
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Source source) throws Exception {
        ValueEnforcer.notNull((Object)source, (String)"XMLSource");
        if (!this.isValidSchematron()) {
            return null;
        }
        Node node = SchematronResourceHelper.getNodeOfSource(source);
        if (node == null) {
            return null;
        }
        return this.applySchematronValidationToSVRL(node);
    }

    @Nonnull
    public static SchematronResourcePure fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourcePure((IReadableResource)new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourcePure((IReadableResource)new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromFile(@Nonnull File file) {
        return new SchematronResourcePure((IReadableResource)new FileSystemResource(file));
    }

    @Nonnull
    public static SchematronResourcePure fromURL(@Nonnull @Nonempty String string) throws MalformedURLException {
        return new SchematronResourcePure((IReadableResource)new URLResource(string));
    }

    @Nonnull
    public static SchematronResourcePure fromURL(@Nonnull URL uRL) {
        return new SchematronResourcePure((IReadableResource)new URLResource(uRL));
    }

    @Nonnull
    public static SchematronResourcePure fromInputStream(@Nonnull InputStream inputStream) {
        return new SchematronResourcePure((IReadableResource)new ReadableResourceInputStream(inputStream));
    }

    @Nonnull
    public static SchematronResourcePure fromByteArray(@Nonnull byte[] byArray) {
        return new SchematronResourcePure((IReadableResource)new ReadableResourceByteArray(byArray));
    }

    @Nonnull
    public static SchematronResourcePure fromString(@Nonnull String string, @Nonnull Charset charset) {
        return SchematronResourcePure.fromByteArray(CharsetManager.getAsBytes((String)string, (Charset)charset));
    }

    @Nonnull
    public static SchematronResourcePure fromSchema(@Nonnull PSSchema pSSchema) {
        return SchematronResourcePure.fromString(new PSWriter().getXMLString(pSSchema), XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ);
    }
}

