/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.compare.ComparatorStringLongestFirst;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.xpath.IPSXPathVariables;
import com.helger.schematron.pure.binding.xpath.PSXPathQueryBinding;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSXPathVariables
implements IPSXPathVariables {
    private final Map<String, String> m_aMap;

    @Nonnull
    @ReturnsMutableCopy
    private static Map<String, String> _createMap() {
        return new TreeMap<String, String>((Comparator<String>)new ComparatorStringLongestFirst());
    }

    public PSXPathVariables() {
        this.m_aMap = PSXPathVariables._createMap();
    }

    public PSXPathVariables(@Nonnull IPSXPathVariables iPSXPathVariables) {
        this.m_aMap = iPSXPathVariables.getAll();
    }

    @Nonnull
    public EChange add(@Nonnull Map.Entry<String, String> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public EChange add(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        String string3 = '$' + string;
        if (this.m_aMap.containsKey(string3)) {
            return EChange.UNCHANGED;
        }
        String string4 = this.getAppliedReplacement(string2);
        this.m_aMap.put(string3, string4);
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getAppliedReplacement(@Nullable String string) {
        return PSXPathQueryBinding.getWithParamTextsReplacedStatic(string, this.m_aMap);
    }

    @Nonnull
    public EChange remove(@Nullable String string) {
        if (StringHelper.hasText((String)string) && this.m_aMap.remove('$' + string) == null) {
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public EChange removeAll(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or((IChangeIndicator)this.remove(string));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAll() {
        Map<String, String> map = PSXPathVariables._createMap();
        map.putAll(this.m_aMap);
        return map;
    }

    @Override
    public boolean contains(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return this.m_aMap.containsKey(string);
    }

    @Override
    @Nullable
    public String get(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return this.m_aMap.get(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PSXPathVariables getClone() {
        return new PSXPathVariables(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).toString();
    }
}

