/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.model.PSDiagnostic;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PSXPathBoundDiagnostic {
    private final PSDiagnostic m_aDiagnostic;
    private final List<PSXPathBoundElement> m_aBoundContent;

    public PSXPathBoundDiagnostic(@Nonnull PSDiagnostic pSDiagnostic, @Nonnull List<PSXPathBoundElement> list) {
        ValueEnforcer.notNull((Object)pSDiagnostic, (String)"Diagnostic");
        ValueEnforcer.notNull(list, (String)"BoundContent");
        this.m_aDiagnostic = pSDiagnostic;
        this.m_aBoundContent = list;
    }

    @Nonnull
    public PSDiagnostic getDiagnostic() {
        return this.m_aDiagnostic;
    }

    @Nonnull
    public List<PSXPathBoundElement> getAllBoundContentElements() {
        return CollectionHelper.newList(this.m_aBoundContent);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("diagnostic", (Object)this.m_aDiagnostic).append("boundContent", this.m_aBoundContent).toString();
    }
}

