/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.helger.schematron.pure.model.PSPattern;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PSXPathBoundPattern {
    private final PSPattern m_aPattern;
    private final List<PSXPathBoundRule> m_aBoundRules;

    public PSXPathBoundPattern(@Nonnull PSPattern pSPattern, @Nonnull List<PSXPathBoundRule> list) {
        ValueEnforcer.notNull((Object)pSPattern, (String)"Pattern");
        ValueEnforcer.notNull(list, (String)"BoundRules");
        this.m_aPattern = pSPattern;
        this.m_aBoundRules = list;
    }

    @Nonnull
    public PSPattern getPattern() {
        return this.m_aPattern;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSXPathBoundRule> getAllBoundRules() {
        return CollectionHelper.newList(this.m_aBoundRules);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("pattern", (Object)this.m_aPattern).append("boundRules", this.m_aBoundRules).toString();
    }
}

