/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.xpath.XPathHelper;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.binding.xpath.IPSXPathVariables;
import com.helger.schematron.pure.binding.xpath.PSXPathVariables;
import com.helger.schematron.pure.bound.AbstractPSBoundSchema;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundPattern;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSName;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.model.PSValueOf;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.validation.SchematronValidationException;
import com.helger.schematron.pure.validation.xpath.PSXPathValidationHandlerSVRL;
import com.helger.schematron.xslt.util.PSErrorListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.ErrorListener;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.xpath.XPathEvaluator;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class PSXPathBoundSchema
extends AbstractPSBoundSchema {
    private final XPathVariableResolver m_aXPathVariableResolver;
    private final XPathFunctionResolver m_aXPathFunctionResolver;
    private final XPathFactory m_aXPathFactory;
    private List<PSXPathBoundPattern> m_aBoundPatterns;

    @Nullable
    private static XPathExpression _compileXPath(@Nonnull XPath xPath, @Nonnull String string) throws XPathExpressionException {
        XPathExpression xPathExpression = null;
        xPathExpression = xPath.compile(string);
        return xPathExpression;
    }

    @Nullable
    private List<PSXPathBoundElement> _createBoundElements(@Nonnull IPSHasMixedContent iPSHasMixedContent, @Nonnull XPath xPath, @Nonnull IPSXPathVariables iPSXPathVariables) {
        ArrayList<PSXPathBoundElement> arrayList = new ArrayList<PSXPathBoundElement>();
        boolean bl = false;
        for (Object object : iPSHasMixedContent.getAllContentElements()) {
            XPathExpression xPathExpression;
            String string;
            IPSClonableElement<PSName> iPSClonableElement;
            if (object instanceof PSName) {
                iPSClonableElement = (PSName)object;
                if (((PSName)iPSClonableElement).hasPath()) {
                    string = iPSXPathVariables.getAppliedReplacement(((PSName)iPSClonableElement).getPath());
                    try {
                        xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                        arrayList.add(new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.error(iPSClonableElement, "Failed to compile XPath expression in <name>: '" + string + "'", xPathExpressionException);
                        bl = true;
                    }
                    continue;
                }
                arrayList.add(new PSXPathBoundElement(iPSClonableElement));
                continue;
            }
            if (object instanceof PSValueOf) {
                iPSClonableElement = (PSValueOf)object;
                string = iPSXPathVariables.getAppliedReplacement(((PSValueOf)iPSClonableElement).getSelect());
                try {
                    xPathExpression = PSXPathBoundSchema._compileXPath(xPath, string);
                    arrayList.add(new PSXPathBoundElement(iPSClonableElement, string, xPathExpression));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(iPSClonableElement, "Failed to compile XPath expression in <value-of>: '" + string + "'", xPathExpressionException);
                    bl = true;
                }
                continue;
            }
            if (object instanceof String) {
                arrayList.add(new PSXPathBoundElement((String)object));
                continue;
            }
            arrayList.add(new PSXPathBoundElement((IPSElement)object));
        }
        if (bl) {
            return null;
        }
        return arrayList;
    }

    @Nullable
    private Map<String, PSXPathBoundDiagnostic> _createBoundDiagnostics(@Nonnull XPath xPath, @Nonnull IPSXPathVariables iPSXPathVariables) {
        HashMap<String, PSXPathBoundDiagnostic> hashMap = new HashMap<String, PSXPathBoundDiagnostic>();
        boolean bl = false;
        PSSchema pSSchema = this.getOriginalSchema();
        if (pSSchema.hasDiagnostics()) {
            for (PSDiagnostic pSDiagnostic : pSSchema.getDiagnostics().getAllDiagnostics()) {
                List<PSXPathBoundElement> list = this._createBoundElements(pSDiagnostic, xPath, iPSXPathVariables);
                if (list == null) {
                    bl = true;
                    continue;
                }
                PSXPathBoundDiagnostic pSXPathBoundDiagnostic = new PSXPathBoundDiagnostic(pSDiagnostic, list);
                if (hashMap.put(pSDiagnostic.getID(), pSXPathBoundDiagnostic) == null) continue;
                this.error(pSDiagnostic, "A diagnostic element with ID '" + pSDiagnostic.getID() + "' was overwritten!");
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return hashMap;
    }

    @Nullable
    private List<PSXPathBoundPattern> _createBoundPatterns(@Nonnull XPath xPath, @Nonnull Map<String, PSXPathBoundDiagnostic> map, @Nonnull IPSXPathVariables iPSXPathVariables) {
        ArrayList<PSXPathBoundPattern> arrayList = new ArrayList<PSXPathBoundPattern>();
        boolean bl = false;
        for (PSPattern pSPattern : this.getAllRelevantPatterns()) {
            PSXPathVariables pSXPathVariables = (PSXPathVariables)iPSXPathVariables.getClone();
            if (pSPattern.hasAnyLet()) {
                for (Map.Entry entry : pSPattern.getAllLetsAsMap().entrySet()) {
                    if (!pSXPathVariables.add(entry).isUnchanged()) continue;
                    this.error(pSPattern, "Duplicate <let> with name '" + (String)entry.getKey() + "' in <pattern>");
                }
            }
            ArrayList arrayList2 = new ArrayList();
            for (PSRule pSRule : pSPattern.getAllRules()) {
                Object object;
                PSXPathVariables pSXPathVariables2 = pSXPathVariables.getClone();
                if (pSRule.hasAnyLet()) {
                    for (Map.Entry entry : pSRule.getAllLetsAsMap().entrySet()) {
                        if (!pSXPathVariables2.add(entry).isUnchanged()) continue;
                        this.error(pSRule, "Duplicate <let> with name '" + (String)entry.getKey() + "' in <rule>");
                    }
                }
                ArrayList arrayList3 = new ArrayList();
                for (PSAssertReport pSAssertReport : pSRule.getAllAssertReports()) {
                    object = pSXPathVariables2.getAppliedReplacement(pSAssertReport.getTest());
                    try {
                        XPathExpression xPathExpression = PSXPathBoundSchema._compileXPath(xPath, (String)object);
                        List<PSXPathBoundElement> list = this._createBoundElements(pSAssertReport, xPath, pSXPathVariables2);
                        if (list == null) {
                            bl = true;
                            continue;
                        }
                        PSXPathBoundAssertReport pSXPathBoundAssertReport = new PSXPathBoundAssertReport(pSAssertReport, (String)object, xPathExpression, list, map);
                        arrayList3.add(pSXPathBoundAssertReport);
                    }
                    catch (Throwable throwable) {
                        this.error(pSAssertReport, "Failed to compile XPath expression in <" + (pSAssertReport.isAssert() ? "assert" : "report") + ">: '" + (String)object + "' with the following variables: " + pSXPathVariables2.getAll(), throwable);
                        bl = true;
                    }
                }
                String string = iPSXPathVariables.getAppliedReplacement(this.getValidationContext(pSRule.getContext()));
                Object var15_24 = null;
                try {
                    object = PSXPathBoundSchema._compileXPath(xPath, string);
                    PSXPathBoundRule pSXPathBoundRule = new PSXPathBoundRule(pSRule, string, (XPathExpression)object, arrayList3);
                    arrayList2.add(pSXPathBoundRule);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to compile XPath expression in <rule>: '" + string + "'", xPathExpressionException);
                    bl = true;
                }
            }
            PSXPathBoundPattern object2 = new PSXPathBoundPattern(pSPattern, arrayList2);
            arrayList.add(object2);
        }
        if (bl) {
            return null;
        }
        return arrayList;
    }

    @Nonnull
    public static XPathFactory createXPathFactorySaxonFirst() throws SchematronBindException {
        XPathFactory xPathFactory;
        try {
            xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "net.sf.saxon.xpath.XPathFactoryImpl", ClassLoaderHelper.getContextClassLoader());
        }
        catch (Exception exception) {
            try {
                xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            }
            catch (Exception exception2) {
                throw new SchematronBindException("Failed to create JAXP XPathFactory", exception2);
            }
        }
        return xPathFactory;
    }

    public PSXPathBoundSchema(@Nonnull IPSQueryBinding iPSQueryBinding, @Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler, @Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver) throws SchematronBindException {
        super(iPSQueryBinding, pSSchema, string, iPSErrorHandler);
        this.m_aXPathVariableResolver = xPathVariableResolver;
        this.m_aXPathFunctionResolver = xPathFunctionResolver;
        this.m_aXPathFactory = PSXPathBoundSchema.createXPathFactorySaxonFirst();
    }

    @Nonnull
    private XPath _createXPathContext() {
        XPath xPath = XPathHelper.createNewXPath((XPathFactory)this.m_aXPathFactory, (XPathVariableResolver)this.m_aXPathVariableResolver, (XPathFunctionResolver)this.m_aXPathFunctionResolver, (NamespaceContext)this.getNamespaceContext());
        if (xPath instanceof XPathEvaluator) {
            XPathEvaluator xPathEvaluator = (XPathEvaluator)xPath;
            xPathEvaluator.getConfiguration().setErrorListener((ErrorListener)new PSErrorListener(this.getErrorHandler()));
        }
        return xPath;
    }

    @Nonnull
    public PSXPathBoundSchema bind() throws SchematronBindException {
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> iterator;
        if (this.m_aBoundPatterns != null) {
            throw new IllegalStateException("bind must only be called once!");
        }
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        PSXPathVariables pSXPathVariables = new PSXPathVariables();
        if (pSSchema.hasAnyLet()) {
            iterator = pSSchema.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (!pSXPathVariables.add(entry).isUnchanged()) continue;
                this.error(pSSchema, "Duplicate <let> with name '" + entry.getKey() + "' in global <schema>");
            }
        }
        if (pSPhase != null) {
            iterator = pSPhase.getAllLetsAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (!pSXPathVariables.add(entry).isUnchanged()) continue;
                this.error(pSSchema, "Duplicate <let> with name '" + entry.getKey() + "' in <phase> with name '" + this.getPhaseID() + "'");
            }
        }
        if ((entry = this._createBoundDiagnostics((XPath)((Object)(iterator = this._createXPathContext())), pSXPathVariables)) == null) {
            throw new SchematronBindException("Failed to precompile the diagnostics of the supplied schema. Check the " + (this.isDefaultErrorHandler() ? "log output" : "error listener") + " for XPath errors!");
        }
        this.m_aBoundPatterns = this._createBoundPatterns((XPath)((Object)iterator), (Map<String, PSXPathBoundDiagnostic>)((Object)entry), pSXPathVariables);
        if (this.m_aBoundPatterns == null) {
            throw new SchematronBindException("Failed to precompile the supplied schema.");
        }
        return this;
    }

    @Nullable
    public XPathVariableResolver getXPathVariableResolver() {
        return this.m_aXPathVariableResolver;
    }

    @Nullable
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.m_aXPathFunctionResolver;
    }

    @Override
    @Nonnull
    public String getValidationContext(@Nonnull String string) {
        if (string.startsWith("/")) {
            return string;
        }
        return "//" + string;
    }

    @Override
    public void validate(@Nonnull Node node, @Nonnull IPSValidationHandler iPSValidationHandler) throws SchematronValidationException {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)iPSValidationHandler, (String)"ValidationHandler");
        if (this.m_aBoundPatterns == null) {
            throw new IllegalStateException("bind was never called!");
        }
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        iPSValidationHandler.onStart(pSSchema, pSPhase);
        for (PSXPathBoundPattern pSXPathBoundPattern : this.m_aBoundPatterns) {
            PSPattern pSPattern = pSXPathBoundPattern.getPattern();
            iPSValidationHandler.onPattern(pSPattern);
            for (PSXPathBoundRule pSXPathBoundRule : pSXPathBoundPattern.getAllBoundRules()) {
                PSRule pSRule = pSXPathBoundRule.getRule();
                NodeList nodeList = null;
                try {
                    nodeList = (NodeList)pSXPathBoundRule.getBoundRuleExpression().evaluate(node, XPathConstants.NODESET);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to evaluate XPath expression to a nodeset: '" + pSXPathBoundRule.getRuleExpression() + "'", xPathExpressionException);
                    continue;
                }
                int n = nodeList.getLength();
                if (n <= 0) continue;
                for (PSXPathBoundAssertReport pSXPathBoundAssertReport : pSXPathBoundRule.getAllBoundAssertReports()) {
                    iPSValidationHandler.onRule(pSRule, pSXPathBoundRule.getRuleExpression());
                    PSAssertReport pSAssertReport = pSXPathBoundAssertReport.getAssertReport();
                    boolean bl = pSAssertReport.isAssert();
                    XPathExpression xPathExpression = pSXPathBoundAssertReport.getBoundTestExpression();
                    for (int i = 0; i < n; ++i) {
                        Node node2 = nodeList.item(i);
                        try {
                            boolean bl2 = (Boolean)xPathExpression.evaluate(node2, XPathConstants.BOOLEAN);
                            if (!(bl ? !bl2 && iPSValidationHandler.onFailedAssert(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak() : bl2 && iPSValidationHandler.onSuccessfulReport(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak())) continue;
                            return;
                        }
                        catch (XPathExpressionException xPathExpressionException) {
                            this.error(pSRule, "Failed to evaluate XPath expression to a boolean: '" + pSXPathBoundAssertReport.getTestExpression() + "'", xPathExpressionException);
                        }
                    }
                }
            }
        }
        iPSValidationHandler.onEnd(pSSchema, pSPhase);
    }

    @Override
    @Nonnull
    public SchematronOutputType validateComplete(@Nonnull Node node) throws SchematronValidationException {
        PSXPathValidationHandlerSVRL pSXPathValidationHandlerSVRL = new PSXPathValidationHandlerSVRL(this.getErrorHandler());
        this.validate(node, pSXPathValidationHandlerSVRL);
        return pSXPathValidationHandlerSVRL.getSVRL();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("boundPatterns", this.m_aBoundPatterns).toString();
    }
}

