/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPSErrorHandler
implements IPSErrorHandler {
    private final IPSErrorHandler m_aNestedErrorHandler;

    protected AbstractPSErrorHandler() {
        this(null);
    }

    protected AbstractPSErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        this.m_aNestedErrorHandler = iPSErrorHandler;
    }

    @Nullable
    public IPSErrorHandler getNestedErrorHandler() {
        return this.m_aNestedErrorHandler;
    }

    protected abstract void handle(@Nullable IReadableResource var1, @Nonnull IErrorLevel var2, @Nullable IPSElement var3, @Nonnull String var4, @Nullable Throwable var5);

    @Override
    public final void warn(@Nullable IReadableResource iReadableResource, @Nullable IPSElement iPSElement, @Nonnull String string) {
        this.handle(iReadableResource, (IErrorLevel)EErrorLevel.WARN, iPSElement, string, null);
        IPSErrorHandler iPSErrorHandler = this.getNestedErrorHandler();
        if (iPSErrorHandler != null) {
            iPSErrorHandler.warn(iReadableResource, iPSElement, string);
        }
    }

    @Override
    public final void error(@Nullable IPSElement iPSElement, @Nonnull String string) {
        this.error(null, iPSElement, string, null);
    }

    @Override
    public final void error(@Nullable IReadableResource iReadableResource, @Nullable IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        this.handle(iReadableResource, (IErrorLevel)EErrorLevel.ERROR, iPSElement, string, throwable);
        IPSErrorHandler iPSErrorHandler = this.getNestedErrorHandler();
        if (iPSErrorHandler != null) {
            iPSErrorHandler.error(iReadableResource, iPSElement, string, throwable);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("nestedErrorHandler", (Object)this.m_aNestedErrorHandler).toString();
    }
}

