/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.error.IResourceLocation;
import com.helger.commons.error.ResourceError;
import com.helger.commons.error.ResourceErrorGroup;
import com.helger.commons.error.ResourceLocation;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasID;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectingPSErrorHandler
extends AbstractPSErrorHandler {
    private final ResourceErrorGroup m_aErrors = new ResourceErrorGroup();

    public CollectingPSErrorHandler() {
    }

    public CollectingPSErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
    }

    @Override
    protected void handle(@Nullable IReadableResource iReadableResource, @Nonnull IErrorLevel iErrorLevel, @Nullable IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        String string2 = "";
        if (iPSElement != null) {
            string2 = string2 + ClassHelper.getClassLocalName((Object)iPSElement);
            if (iPSElement instanceof IPSHasID && ((IPSHasID)((Object)iPSElement)).hasID()) {
                string2 = string2 + " [ID=" + ((IPSHasID)((Object)iPSElement)).getID() + "]";
            }
        }
        ResourceLocation resourceLocation = new ResourceLocation(iReadableResource == null ? null : iReadableResource.getResourceID(), string2);
        this.m_aErrors.addResourceError((IResourceError)new ResourceError((IResourceLocation)resourceLocation, iErrorLevel, string, throwable));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getResourceErrors() {
        return this.m_aErrors.getClone();
    }

    @Nonnull
    public List<IResourceError> getAllResourceErrors() {
        return this.m_aErrors.getAllResourceErrors();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getAllFailures() {
        return this.m_aErrors.getAllFailures();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getAllErrors() {
        return this.m_aErrors.getAllErrors();
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aErrors.clear();
    }

    public boolean isEmpty() {
        return this.m_aErrors.isEmpty();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("errors", (Object)this.m_aErrors).toString();
    }
}

