/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.commons.error.IErrorLevel;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.log.LogHelper;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPSErrorHandler
extends AbstractPSErrorHandler {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingPSErrorHandler.class);

    public LoggingPSErrorHandler() {
    }

    public LoggingPSErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
    }

    @Nonnull
    public static String getLogMessage(@Nullable IReadableResource iReadableResource, @Nullable IPSElement iPSElement, @Nonnull String string) {
        return StringHelper.getImplodedNonEmpty((String)" - ", (String[])new String[]{iReadableResource == null ? null : iReadableResource.getPath(), iPSElement == null ? null : ClassHelper.getClassLocalName((Object)iPSElement), iPSElement instanceof IPSHasID && ((IPSHasID)((Object)iPSElement)).hasID() ? "ID " + ((IPSHasID)((Object)iPSElement)).getID() : null, string});
    }

    @Override
    protected void handle(@Nullable IReadableResource iReadableResource, @Nonnull IErrorLevel iErrorLevel, @Nullable IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        LogHelper.log((Logger)s_aLogger, (IErrorLevel)iErrorLevel, (String)LoggingPSErrorHandler.getLogMessage(iReadableResource, iPSElement, string), (Throwable)throwable);
    }
}

