/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDiagnostic;
import com.helger.schematron.pure.model.PSInclude;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDiagnostics
implements IPSElement,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasIncludes {
    private final List<PSInclude> m_aIncludes = new ArrayList<PSInclude>();
    private final List<PSDiagnostic> m_aDiagnostics = new ArrayList<PSDiagnostic>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
            if (pSDiagnostic.isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (PSInclude iPSElement : this.m_aIncludes) {
            iPSElement.validateCompletely(iPSErrorHandler);
        }
        for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
            pSDiagnostic.validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        ValueEnforcer.notNull(list, (String)"ForeignElements");
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return CollectionHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return CollectionHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aIncludes.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return !this.m_aIncludes.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<PSInclude> getAllIncludes() {
        return CollectionHelper.newList(this.m_aIncludes);
    }

    public void addDiagnostic(@Nonnull PSDiagnostic pSDiagnostic) {
        ValueEnforcer.notNull((Object)pSDiagnostic, (String)"Diagnostic");
        this.m_aDiagnostics.add(pSDiagnostic);
    }

    @Nullable
    public PSDiagnostic getDiagnosticOfID(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
                if (!string.equals(pSDiagnostic.getID())) continue;
                return pSDiagnostic;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSDiagnostic> getAllDiagnostics() {
        return CollectionHelper.newList(this.m_aDiagnostics);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "diagnostics");
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            microElement.appendChild((IMicroNode)pSInclude.getAsMicroElement());
        }
        for (PSDiagnostic pSDiagnostic : this.m_aDiagnostics) {
            microElement.appendChild((IMicroNode)pSDiagnostic.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotEmpty("includes", this.m_aIncludes).appendIfNotEmpty("diagnostics", this.m_aDiagnostics).appendIfNotEmpty("foreignAttrs", this.m_aForeignAttrs).appendIfNotEmpty("foreignElements", this.m_aForeignElements).toString();
    }
}

