/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSExtends
implements IPSElement,
IPSHasForeignAttributes {
    private String m_sRule;
    private Map<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sRule)) {
            iPSErrorHandler.error(this, "<extends> has no 'rule'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sRule)) {
            iPSErrorHandler.error(this, "<extends> has no 'rule'");
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return CollectionHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setRule(@Nullable String string) {
        this.m_sRule = string;
    }

    @Nullable
    public String getRule() {
        return this.m_sRule;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "extends");
        microElement.setAttribute("rule", this.m_sRule);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry<String, String> entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("rule", (Object)this.m_sRule).appendIfNotEmpty("foreignAttrs", this.m_aForeignAttrs).toString();
    }
}

