/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasForeignAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSNS
implements IPSClonableElement<PSNS>,
IPSHasForeignAttributes {
    private String m_sUri;
    private String m_sPrefix;
    private Map<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sUri)) {
            iPSErrorHandler.error(this, "<ns> has no 'uri'");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sPrefix)) {
            iPSErrorHandler.error(this, "<ns> has no 'prefix'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText((String)this.m_sUri)) {
            iPSErrorHandler.error(this, "<ns> has no 'uri'");
        }
        if (StringHelper.hasNoText((String)this.m_sPrefix)) {
            iPSErrorHandler.error(this, "<ns> has no 'prefix'");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return CollectionHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setUri(@Nullable String string) {
        this.m_sUri = string;
    }

    @Nullable
    public String getUri() {
        return this.m_sUri;
    }

    public void setPrefix(@Nullable String string) {
        this.m_sPrefix = string;
    }

    @Nullable
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "ns");
        microElement.setAttribute("prefix", this.m_sPrefix);
        microElement.setAttribute("uri", this.m_sUri);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry<String, String> entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSNS getClone() {
        PSNS pSNS = new PSNS();
        pSNS.setUri(this.m_sUri);
        pSNS.setPrefix(this.m_sPrefix);
        if (this.hasForeignAttributes()) {
            pSNS.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSNS;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("uri", (Object)this.m_sUri).appendIfNotNull("prefix", (Object)this.m_sPrefix).appendIfNotEmpty("foreignAttrs", this.m_aForeignAttrs).toString();
    }
}

