/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.IPSOptionalElement;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSSpan;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSP
implements IPSElement,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasMixedContent,
IPSHasID {
    private String m_sID;
    private String m_sClass;
    private String m_sIcon;
    private final List<Object> m_aContent = new ArrayList<Object>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement) || ((IPSElement)object).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement)) continue;
            ((IPSElement)object).validateCompletely(iPSErrorHandler);
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        ValueEnforcer.notNull(list, (String)"ForeignElements");
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return CollectionHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return CollectionHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    public boolean hasID() {
        return this.m_sID != null;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public void setClazz(@Nullable String string) {
        this.m_sClass = string;
    }

    @Nullable
    public String getClazz() {
        return this.m_sClass;
    }

    public void setIcon(@Nullable String string) {
        this.m_sIcon = string;
    }

    @Nullable
    public String getIcon() {
        return this.m_sIcon;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllTexts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }

    @Nullable
    public String getText() {
        return StringHelper.getImploded((String)"", this.m_aContent);
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull((Object)pSDir, (String)"Dir");
        this.m_aContent.add(pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSDir> getAllDirs() {
        ArrayList<PSDir> arrayList = new ArrayList<PSDir>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSDir)) continue;
            arrayList.add((PSDir)object);
        }
        return arrayList;
    }

    public void addEmph(@Nonnull PSEmph pSEmph) {
        if (pSEmph == null) {
            throw new NullPointerException("Emph");
        }
        this.m_aContent.add(pSEmph);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSEmph> getAllEmphs() {
        ArrayList<PSEmph> arrayList = new ArrayList<PSEmph>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSEmph)) continue;
            arrayList.add((PSEmph)object);
        }
        return arrayList;
    }

    public void addSpan(@Nonnull PSSpan pSSpan) {
        ValueEnforcer.notNull((Object)pSSpan, (String)"Span");
        this.m_aContent.add(pSSpan);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSSpan> getAllSpans() {
        ArrayList<PSSpan> arrayList = new ArrayList<PSSpan>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSSpan)) continue;
            arrayList.add((PSSpan)object);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<Object> getAllContentElements() {
        return CollectionHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "p");
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("class", this.m_sClass);
        microElement.setAttribute("icon", this.m_sIcon);
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                microElement.appendText((CharSequence)((String)object));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("class", (Object)this.m_sClass).appendIfNotNull("icon", (Object)this.m_sIcon).appendIfNotEmpty("content", this.m_aContent).appendIfNotEmpty("foreignAttrs", this.m_aForeignAttrs).appendIfNotEmpty("foreignElements", this.m_aForeignElements).toString();
    }
}

